/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.it.datasetbuilder.mappers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.squashtest.it.datasetbuilder.CustomFieldData;
import org.squashtest.it.datasetbuilder.DatasetData;
import org.squashtest.it.datasetbuilder.InfoListProject;
import org.squashtest.it.datasetbuilder.TableRow;
import org.squashtest.it.datasetbuilder.api.model.ApiTokenModel;
import org.squashtest.it.datasetbuilder.api.model.CoreUserModel;
import org.squashtest.it.datasetbuilder.api.model.CustomFieldModel;
import org.squashtest.it.datasetbuilder.api.model.InfoListModel;
import org.squashtest.it.datasetbuilder.api.model.MilestoneModel;
import org.squashtest.it.datasetbuilder.api.model.ProjectAiConfigurationModel;
import org.squashtest.it.datasetbuilder.api.model.ProjectModel;
import org.squashtest.it.datasetbuilder.api.model.PromptSetModel;
import org.squashtest.it.datasetbuilder.api.model.RequirementVersionLinkTypeModel;
import org.squashtest.it.datasetbuilder.api.model.SquashModel;
import org.squashtest.it.datasetbuilder.api.model.TestCandidateAnalysisModel;
import org.squashtest.it.datasetbuilder.api.model.TestCaseLibraryNodeModel;
import org.squashtest.it.datasetbuilder.api.model.TestCaseModel;
import org.squashtest.it.datasetbuilder.api.model.ThirdPartyServerModel;
import org.squashtest.it.datasetbuilder.entitybuilder.BuilderAdminWsEntities;
import org.squashtest.it.datasetbuilder.entitybuilder.BuilderApiToken;
import org.squashtest.it.datasetbuilder.entitybuilder.BuilderTestCandidateAnalysis;
import org.squashtest.it.datasetbuilder.mappers.CoreUserMapper;
import org.squashtest.it.datasetbuilder.mappers.CustomFieldMapper;
import org.squashtest.it.datasetbuilder.mappers.InfoListMapper;
import org.squashtest.it.datasetbuilder.mappers.ProjectAiConfigurationMapper;
import org.squashtest.it.datasetbuilder.mappers.ProjectMapper;
import org.squashtest.it.datasetbuilder.mappers.PromptSetMapper;
import org.squashtest.it.datasetbuilder.mappers.ServerMapper;
import org.squashtest.tm.domain.customfield.BindableEntity;

public final class SquashMapper {
    private SquashMapper() {
        throw new AssertionError((Object)"Cannot instantiate utility class");
    }

    public static DatasetData toDatasetData(SquashModel model) {
        DatasetData datasetData = new DatasetData(new ArrayList<TableRow>(), new ArrayList<TableRow>());
        CustomFieldData customFieldData = SquashMapper.mapCustomField(model.getCustomFields(), datasetData);
        Map<Long, Long> defaultItemIdByInfoListId = SquashMapper.mapInfoList(model.getInfoLists(), datasetData);
        SquashMapper.mapPromptSet(model.getPromptSets(), datasetData);
        SquashMapper.mapCoreUser(model.getUsers(), datasetData);
        SquashMapper.mapApiToken(model.getApiTokens(), datasetData);
        SquashMapper.mapMilestone(model.getMilestones(), datasetData);
        SquashMapper.mapServer(model.getServers(), datasetData);
        SquashMapper.mapRequirementLink(model.getRequirementVersionLinkTypes(), datasetData);
        SquashMapper.mapProject(model.getProjects(), customFieldData, defaultItemIdByInfoListId, datasetData);
        SquashMapper.mapProjectAiConfiguration(model.getProjectAiConfigurations(), datasetData);
        SquashMapper.mapTestCandidateAnalysis(model.getTestCandidateAnalyses(), datasetData);
        return datasetData;
    }

    private static void mapCoreUser(List<CoreUserModel> coreUserModels, DatasetData datasetData) {
        coreUserModels.forEach(coreUser -> datasetData.addDatasetData(CoreUserMapper.toDatasetData(coreUser)));
    }

    private static void mapPromptSet(List<PromptSetModel> promptSetModels, DatasetData datasetData) {
        promptSetModels.forEach(promptSetModel -> {
            PromptSetMapper.PromptSetData promptSetData = PromptSetMapper.toPromptSetData(promptSetModel);
            datasetData.addTableRowInsert(promptSetData.tableRows());
        });
    }

    private static CustomFieldData mapCustomField(List<CustomFieldModel> models, DatasetData datasetData) {
        models.forEach(customField -> {
            customField.withCode(Optional.ofNullable(customField.getCode()).orElse("code%s".formatted(customField.getCufId())));
            customField.withLabel(Optional.ofNullable(customField.getLabel()).orElse("label%s".formatted(customField.getCufId())));
            datasetData.addDatasetData(CustomFieldMapper.toDatasetData(customField));
        });
        return new CustomFieldData(new ArrayList<CustomFieldModel>(models), new HashMap<Pair<Long, BindableEntity>, List<CustomFieldData.CustomFieldValueData>>());
    }

    private static Map<Long, Long> mapInfoList(List<InfoListModel> models, DatasetData datasetData) {
        HashMap<Long, Long> defaultItemIdByInfoListId = new HashMap<Long, Long>();
        for (InfoListModel infoListModel : models) {
            InfoListMapper.InfoListData infoListData = InfoListMapper.toInfoListData(infoListModel);
            datasetData.addTableRowInsert(infoListData.tableRows());
            defaultItemIdByInfoListId.put(infoListData.infoListId(), infoListData.defaultItemId());
        }
        SquashMapper.addSystemInfoList(defaultItemIdByInfoListId, InfoListProject.REQ_CATEGORY);
        SquashMapper.addSystemInfoList(defaultItemIdByInfoListId, InfoListProject.TC_NATURE);
        SquashMapper.addSystemInfoList(defaultItemIdByInfoListId, InfoListProject.TC_TYPE);
        return defaultItemIdByInfoListId;
    }

    private static void addSystemInfoList(Map<Long, Long> defaultItemIdByInfoListId, InfoListProject infoListProject) {
        defaultItemIdByInfoListId.put(infoListProject.getSystemInfoListId(), infoListProject.getSystemDefaultItemId());
    }

    private static void mapProject(List<ProjectModel> models, CustomFieldData customFieldData, Map<Long, Long> defaultItemIdByInfoListId, DatasetData datasetData) {
        Map<Long, TestCaseModel> testCaseModelByTclnId = SquashMapper.getTestcaseModelById(models);
        models.forEach(project -> datasetData.addDatasetData(ProjectMapper.toDatasetData(project, customFieldData, defaultItemIdByInfoListId, testCaseModelByTclnId)));
    }

    private static void mapProjectAiConfiguration(List<ProjectAiConfigurationModel> projectAiConfigurationModels, DatasetData datasetData) {
        projectAiConfigurationModels.forEach(projectAiConfigurationModel -> datasetData.addDatasetData(ProjectAiConfigurationMapper.toDatasetData(projectAiConfigurationModel)));
    }

    private static void mapTestCandidateAnalysis(List<TestCandidateAnalysisModel> models, DatasetData datasetData) {
        models.forEach(testCandidateAnalysis -> datasetData.addTableRowInsert(BuilderTestCandidateAnalysis.getTestCandidateAnalysisTableRow(testCandidateAnalysis)));
    }

    private static void mapApiToken(List<ApiTokenModel> models, DatasetData datasetData) {
        models.forEach(apiToken -> datasetData.addTableRowInsert(BuilderApiToken.getApiTokenTableRow(apiToken)));
    }

    private static void mapMilestone(List<MilestoneModel> models, DatasetData datasetData) {
        models.forEach(model -> datasetData.addTableRowInsert(BuilderAdminWsEntities.getMilestoneTableRow(model)));
    }

    private static void mapServer(List<ThirdPartyServerModel> models, DatasetData datasetData) {
        models.forEach(model -> datasetData.addDatasetData(ServerMapper.toDatasetData(model)));
    }

    private static void mapRequirementLink(List<RequirementVersionLinkTypeModel> models, DatasetData datasetData) {
        models.forEach(model -> datasetData.addTableRowInsert(BuilderAdminWsEntities.getRequirementVersionLinkTypeTableRow(model)));
    }

    private static Map<Long, TestCaseModel> getTestcaseModelById(List<ProjectModel> models) {
        return models.stream().flatMap(model -> model.getTestCaseLibraryNodes().stream().filter(TestCaseModel.class::isInstance)).collect(Collectors.toMap(TestCaseLibraryNodeModel::getTclnId, TestCaseModel.class::cast, (existing, replacement) -> {
            throw new IllegalArgumentException("Duplicate test case id: " + String.valueOf(existing.getTclnId()));
        }));
    }
}

