/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.it.datasetbuilder;

import java.io.InputStream;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.CachedDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.stream.IDataSetProducer;
import org.dbunit.dataset.xml.FlatXmlProducer;
import org.dbunit.ext.mysql.MySqlConnection;
import org.dbunit.ext.postgresql.PostgresqlDataTypeFactory;
import org.dbunit.operation.DatabaseOperation;
import org.squashtest.it.datasetbuilder.DatabaseType;
import org.squashtest.it.datasetbuilder.DatasetLoaderException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public final class DatasetLoader {
    private DatasetLoader() {
        throw new AssertionError((Object)"Cannot instantiate utility class");
    }

    public static void loadDataset(Connection dbConnection, String[] datasetsXml, DatabaseType databaseType) throws DatasetLoaderException {
        try {
            DatabaseConnection connection = switch (databaseType) {
                case DatabaseType.POSTGRESQL -> {
                    DatabaseConnection pgConnection = new DatabaseConnection(dbConnection);
                    pgConnection.getConfig().setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new PostgresqlDataTypeFactory());
                    yield pgConnection;
                }
                case DatabaseType.MARIA_DB -> {
                    MySqlConnection mariadbConnection = new MySqlConnection(dbConnection, dbConnection.getCatalog());
                    mariadbConnection.getConfig().setProperty("http://www.dbunit.org/properties/escapePattern", (Object)"`?`");
                    yield mariadbConnection;
                }
                case DatabaseType.H2 -> new DatabaseConnection(dbConnection);
                default -> throw new MatchException(null, null);
            };
            connection.getConfig().setProperty("http://www.dbunit.org/features/allowEmptyFields", (Object)true);
            DatasetLoader.loadDatasetToDatabase((IDatabaseConnection)connection, datasetsXml[0], DatabaseOperation.INSERT);
            DatasetLoader.loadDatasetToDatabase((IDatabaseConnection)connection, datasetsXml[1], DatabaseOperation.UPDATE);
        }
        catch (SQLException | DatabaseUnitException e) {
            throw new DatasetLoaderException("Failed to load dataset", e);
        }
    }

    private static void loadDatasetToDatabase(IDatabaseConnection connection, String datasetXml, DatabaseOperation databaseOperation) throws DatabaseUnitException, SQLException {
        InputSource source = new InputSource(new StringReader(datasetXml));
        FlatXmlProducer producer = new FlatXmlProducer(source, (EntityResolver)new ClasspathEntityResolver());
        CachedDataSet dataSet = new CachedDataSet((IDataSetProducer)producer);
        databaseOperation.execute(connection, (IDataSet)dataSet);
    }

    static class ClasspathEntityResolver
    implements EntityResolver {
        ClasspathEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            if (systemId != null && systemId.startsWith("classpath:")) {
                String path = systemId.substring("classpath:".length());
                InputStream is = this.getClass().getClassLoader().getResourceAsStream(path);
                return new InputSource(is);
            }
            return null;
        }
    }
}

