/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.it.datasetbuilder.mappers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.squashtest.it.datasetbuilder.CustomFieldData;
import org.squashtest.it.datasetbuilder.DatasetData;
import org.squashtest.it.datasetbuilder.SequenceGenerator;
import org.squashtest.it.datasetbuilder.TableRow;
import org.squashtest.it.datasetbuilder.api.model.CustomFieldModel;
import org.squashtest.it.datasetbuilder.api.model.ProjectModel;
import org.squashtest.it.datasetbuilder.api.model.TestCaseModel;
import org.squashtest.it.datasetbuilder.entitybuilder.BuilderGlobalEntities;
import org.squashtest.it.datasetbuilder.entitybuilder.BuilderProject;
import org.squashtest.it.datasetbuilder.mappers.ActionWordLibraryNodeMapper;
import org.squashtest.it.datasetbuilder.mappers.CampaignLibraryNodeMapper;
import org.squashtest.it.datasetbuilder.mappers.CustomFieldMapper;
import org.squashtest.it.datasetbuilder.mappers.RequirementLibraryNodeMapper;
import org.squashtest.it.datasetbuilder.mappers.TestCaseLibraryNodeMapper;
import org.squashtest.it.datasetbuilder.rowbuilders.ActionWordLibraryNodeRow;
import org.squashtest.it.datasetbuilder.rowbuilders.ActionWordLibraryRow;
import org.squashtest.it.datasetbuilder.rowbuilders.AttachmentListRow;
import org.squashtest.it.datasetbuilder.rowbuilders.AutomationRequestLibraryRow;
import org.squashtest.it.datasetbuilder.rowbuilders.CampaignLibraryRow;
import org.squashtest.it.datasetbuilder.rowbuilders.MilestoneBindingRow;
import org.squashtest.it.datasetbuilder.rowbuilders.RequirementLibraryRow;
import org.squashtest.it.datasetbuilder.rowbuilders.TestCaseLibraryRow;
import org.squashtest.tm.domain.actionword.ActionWordTreeDefinition;
import org.squashtest.tm.domain.customfield.BindableEntity;

public final class ProjectMapper {
    private ProjectMapper() {
        throw new AssertionError((Object)"Cannot instantiate utility class");
    }

    public static DatasetData toDatasetData(ProjectModel projectModel) {
        return ProjectMapper.toDatasetData(projectModel, new CustomFieldData(new ArrayList<CustomFieldModel>(), new HashMap<Pair<Long, BindableEntity>, List<CustomFieldData.CustomFieldValueData>>()), new HashMap<Long, Long>(), new HashMap<Long, TestCaseModel>());
    }

    public static DatasetData toDatasetData(ProjectModel model, CustomFieldData customFieldData, Map<Long, Long> defaultItemIdByInfoListId, Map<Long, TestCaseModel> testCaseModelByTclnId) {
        long rlAttachmentListId = AttachmentListRow.sequence.nextId();
        long tclAttachmentListId = AttachmentListRow.sequence.nextId();
        long clAttachmentListId = AttachmentListRow.sequence.nextId();
        long awlAttachmentListId = AttachmentListRow.sequence.nextId();
        long projectAttachmentListId = AttachmentListRow.sequence.nextId();
        long arlAttachmentListId = AttachmentListRow.sequence.nextId();
        long rlId = RequirementLibraryRow.sequence.nextId();
        long tclId = TestCaseLibraryRow.sequence.nextId();
        long clId = CampaignLibraryRow.sequence.nextId();
        long awlId = ActionWordLibraryRow.sequence.nextId();
        long arlId = AutomationRequestLibraryRow.sequence.nextId();
        DatasetData datasetData = new DatasetData(new ArrayList<TableRow>(), new ArrayList<TableRow>());
        ProjectData projectData = new ProjectData(model.getProjectId(), rlId, tclId, clId, awlId, arlId, defaultItemIdByInfoListId.getOrDefault(model.getReqCategoryInfoListId(), null), defaultItemIdByInfoListId.getOrDefault(model.getTcNatureInfoListId(), null), defaultItemIdByInfoListId.getOrDefault(model.getTcTypeInfoListId(), null), customFieldData, testCaseModelByTclnId, new HashMap<BindableEntity, Map<Long, List<DenormalizedData>>>());
        datasetData.addTableRowInsert(BuilderGlobalEntities.getAttachmentListTableRow(projectAttachmentListId), BuilderGlobalEntities.getAttachmentListTableRow(rlAttachmentListId), BuilderGlobalEntities.getAttachmentListTableRow(tclAttachmentListId), BuilderGlobalEntities.getAttachmentListTableRow(clAttachmentListId), BuilderGlobalEntities.getAttachmentListTableRow(awlAttachmentListId), BuilderGlobalEntities.getAttachmentListTableRow(arlAttachmentListId), BuilderProject.getRequirementLibraryTableRow(rlId, rlAttachmentListId), BuilderProject.getTestCaseLibraryTableRow(tclId, tclAttachmentListId), BuilderProject.getCampaignLibraryTableRow(clId, clAttachmentListId), BuilderProject.getActionWordLibraryTableRow(awlId, awlAttachmentListId), BuilderProject.getAutomationRequestLibraryTableRow(arlId, arlAttachmentListId), BuilderProject.getProjectTableRow(model, projectAttachmentListId, projectData));
        ProjectMapper.mapCustomFieldBindings(model, datasetData, projectData);
        ProjectMapper.mapMilestoneBindings(model, datasetData, projectData);
        ProjectMapper.mapTestAutomationProject(model, datasetData);
        ProjectMapper.mapRequirementLibraryNodes(model, datasetData, projectData);
        ProjectMapper.mapTestCaseLibraryNodes(model, datasetData, projectData);
        ProjectMapper.mapCampaignLibraryNodes(model, datasetData, projectData);
        ProjectMapper.mapActionWordLibraryNodes(model, datasetData, projectData);
        return datasetData;
    }

    private static void mapCustomFieldBindings(ProjectModel model, DatasetData datasetData, ProjectData projectData) {
        if (projectData.customFieldData != null) {
            SequenceGenerator positionGenerator = new SequenceGenerator();
            model.getCustomFieldBindings().forEach(customFieldBinding -> datasetData.addDatasetData(CustomFieldMapper.toDatasetData(customFieldBinding, projectData.customFieldData, projectData.projectId, positionGenerator)));
        }
    }

    private static void mapMilestoneBindings(ProjectModel model, DatasetData datasetData, ProjectData projectData) {
        model.getMilestoneIds().forEach(milestoneBinding -> {
            Long milestoneBindingId = MilestoneBindingRow.sequence.nextId();
            datasetData.addTableRowInsert(BuilderProject.getMilestoneBindingTableRow(milestoneBindingId, milestoneBinding, projectData.projectId));
        });
    }

    private static void mapTestAutomationProject(ProjectModel model, DatasetData datasetData) {
        if (!model.getTestAutomationProjects().isEmpty() && model.getTaServerId() == null) {
            throw new IllegalArgumentException("Test Automation Server ID must be set when defining Test Automation Projects");
        }
        model.getTestAutomationProjects().forEach(taModel -> datasetData.addTableRowInsert(BuilderProject.getTestAutomationProjectTableRow(taModel, model.getProjectId(), model.getTaServerId())));
    }

    private static void mapRequirementLibraryNodes(ProjectModel model, DatasetData datasetData, ProjectData projectData) {
        SequenceGenerator rlContentOrderSequence = new SequenceGenerator();
        datasetData.addDatasetData(model.getRequirementLibraryNodes().stream().map(node -> RequirementLibraryNodeMapper.toDatasetData(node, rlContentOrderSequence, projectData)).toList());
    }

    private static void mapTestCaseLibraryNodes(ProjectModel model, DatasetData datasetData, ProjectData projectData) {
        SequenceGenerator tclContentOrderSequence = new SequenceGenerator();
        datasetData.addDatasetData(model.getTestCaseLibraryNodes().stream().map(node -> TestCaseLibraryNodeMapper.toDatasetData(node, tclContentOrderSequence, projectData)).toList());
    }

    private static void mapCampaignLibraryNodes(ProjectModel model, DatasetData datasetData, ProjectData projectData) {
        SequenceGenerator clContentOrderSequence = new SequenceGenerator();
        datasetData.addDatasetData(model.getCampaignLibraryNodes().stream().map(node -> CampaignLibraryNodeMapper.toDatasetData(node, clContentOrderSequence, projectData)).toList());
    }

    private static void mapActionWordLibraryNodes(ProjectModel model, DatasetData datasetData, ProjectData projectData) {
        Long libraryNodeId = ActionWordLibraryNodeRow.sequence.nextId();
        datasetData.addTableRowInsert(ActionWordLibraryNodeRow.builder().withName((Object)model.getName()).withAwlId((Object)projectData.awlId).withAwlnId((Object)libraryNodeId).withEntityId((Object)projectData.awlId).withEntityType((Object)ActionWordTreeDefinition.LIBRARY.name()).build().toTableRow());
        datasetData.addDatasetData(model.getActionWordLibraryNodes().stream().map(node -> ActionWordLibraryNodeMapper.toDatasetData(node, projectData, libraryNodeId)).toList());
    }

    public record DenormalizedData(CustomFieldData.CustomFieldValueData customFieldValueData, Long cfvId) {
    }

    public record ProjectData(Long projectId, Long rlId, Long tclId, Long clid, Long awlId, Long arlId, Long defaultCategoryItemId, Long defaultNatureItemId, Long defaultTypeItemId, CustomFieldData customFieldData, Map<Long, TestCaseModel> testCaseModelByTclnId, Map<BindableEntity, Map<Long, List<DenormalizedData>>> denormalizedDataByBindableEntity) {
    }
}

