/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.it.datasetbuilder.mappers;

import java.util.ArrayList;
import java.util.Date;
import org.squashtest.it.datasetbuilder.DatasetData;
import org.squashtest.it.datasetbuilder.DateFormatters;
import org.squashtest.it.datasetbuilder.SequenceGenerator;
import org.squashtest.it.datasetbuilder.TableRow;
import org.squashtest.it.datasetbuilder.api.model.ActionWordLibraryNodeModel;
import org.squashtest.it.datasetbuilder.api.model.ActionWordModel;
import org.squashtest.it.datasetbuilder.mappers.ProjectMapper;
import org.squashtest.it.datasetbuilder.rowbuilders.ActionWordFragmentRow;
import org.squashtest.it.datasetbuilder.rowbuilders.ActionWordLibraryNodeRow;
import org.squashtest.it.datasetbuilder.rowbuilders.ActionWordParameterRow;
import org.squashtest.it.datasetbuilder.rowbuilders.ActionWordRow;
import org.squashtest.it.datasetbuilder.rowbuilders.ActionWordTextRow;
import org.squashtest.it.datasetbuilder.rowbuilders.AwlnRelationshipRow;
import org.squashtest.tm.domain.actionword.ActionWordTreeDefinition;
import org.squashtest.tm.domain.bdd.ActionWord;
import org.squashtest.tm.domain.bdd.ActionWordParameter;
import org.squashtest.tm.domain.bdd.ActionWordText;
import org.squashtest.tm.domain.bdd.LibraryActionWordParser;

public final class ActionWordLibraryNodeMapper {
    private ActionWordLibraryNodeMapper() {
        throw new AssertionError((Object)"Cannot instantiate utility class");
    }

    public static DatasetData toDatasetData(ActionWordLibraryNodeModel node, ProjectMapper.ProjectData projectData, Long parentNodeId) {
        return ActionWordLibraryNodeMapper.mapNode(node, projectData, parentNodeId);
    }

    private static DatasetData mapNode(ActionWordLibraryNodeModel model, ProjectMapper.ProjectData projectData, Long parentNodeId) {
        DatasetData datasetData = new DatasetData(new ArrayList<TableRow>(), new ArrayList<TableRow>());
        LibraryActionWordParser actionWordParser = new LibraryActionWordParser();
        Long awlnId = ActionWordLibraryNodeRow.sequence.nextId();
        if (model instanceof ActionWordModel) {
            ActionWordModel actionWordModel = (ActionWordModel)model;
            ActionWord parsedActionWord = actionWordParser.createActionWordInLibrary(actionWordModel.getWords());
            ActionWordRow actionWordRow = ActionWordRow.builder().withActionWordId((Object)awlnId).withDescription((Object)actionWordModel.getDescription()).withProjectId((Object)projectData.projectId()).withCreatedOn((Object)DateFormatters.shortDate((Date)new Date())).withCreatedBy((Object)actionWordModel.getCreatedBy()).withToken((Object)parsedActionWord.getToken()).withLastImplementationDate((Object)actionWordModel.getLastImplementationDate()).withLastImplementationTechnology((Object)actionWordModel.getLastImplementationTechnology()).build();
            ArrayList actionWordFragmentRows = new ArrayList();
            ArrayList actionWordParameterRows = new ArrayList();
            ArrayList actionWordTextRows = new ArrayList();
            SequenceGenerator fragmentOrderSeqGenerator = new SequenceGenerator();
            parsedActionWord.getFragments().forEach(fragment -> {
                Long fragmentId = ActionWordFragmentRow.sequence.nextId();
                actionWordFragmentRows.add(ActionWordFragmentRow.builder().withActionWordId((Object)awlnId).withActionWordFragmentId((Object)fragmentId).withFragmentOrder((Object)fragmentOrderSeqGenerator.nextId()).build());
                if (fragment instanceof ActionWordParameter) {
                    ActionWordParameter actionWordParameter = (ActionWordParameter)fragment;
                    actionWordParameterRows.add(ActionWordParameterRow.builder().withActionWordFragmentId((Object)fragmentId).withName((Object)actionWordParameter.getName()).withDefaultValue((Object)actionWordParameter.getDefaultValue()).build());
                } else if (fragment instanceof ActionWordText) {
                    ActionWordText actionWordText = (ActionWordText)fragment;
                    actionWordTextRows.add(ActionWordTextRow.builder().withActionWordFragmentId((Object)fragmentId).withText((Object)actionWordText.getText()).build());
                }
            });
            datasetData.addTableRowInsert(actionWordRow.toTableRow());
            actionWordFragmentRows.forEach(fragmentRow -> datasetData.addTableRowInsert(fragmentRow.toTableRow()));
            actionWordParameterRows.forEach(parameterRow -> datasetData.addTableRowInsert(parameterRow.toTableRow()));
            actionWordTextRows.forEach(textRow -> datasetData.addTableRowInsert(textRow.toTableRow()));
            datasetData.addTableRowInsert(ActionWordLibraryNodeRow.builder().withName((Object)parsedActionWord.getName()).withAwlnId((Object)awlnId).withAwlId((Object)projectData.awlId()).withEntityId((Object)awlnId).withEntityType((Object)ActionWordTreeDefinition.ACTION_WORD.name()).build().toTableRow());
            datasetData.addTableRowInsert(AwlnRelationshipRow.builder().withAncestorId((Object)projectData.awlId()).withContentOrder((Object)parentNodeId).withDescendantId((Object)awlnId).build().toTableRow());
            return datasetData;
        }
        throw new IllegalArgumentException("The node must be of type ActionWordModel");
    }
}

