/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.it.datasetbuilder.mappers;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.squashtest.it.datasetbuilder.DatasetData;
import org.squashtest.it.datasetbuilder.SequenceGenerator;
import org.squashtest.it.datasetbuilder.TableRow;
import org.squashtest.it.datasetbuilder.api.model.AutomatedTestModel;
import org.squashtest.it.datasetbuilder.api.model.AutomationRequestModel;
import org.squashtest.it.datasetbuilder.api.model.ExploratoryTestCaseModel;
import org.squashtest.it.datasetbuilder.api.model.KeywordTestCaseModel;
import org.squashtest.it.datasetbuilder.api.model.ScriptedTestCaseModel;
import org.squashtest.it.datasetbuilder.api.model.StandardTestCaseModel;
import org.squashtest.it.datasetbuilder.api.model.TestCaseFolderModel;
import org.squashtest.it.datasetbuilder.api.model.TestCaseLibraryNodeModel;
import org.squashtest.it.datasetbuilder.api.model.TestCaseModel;
import org.squashtest.it.datasetbuilder.entitybuilder.BuilderGlobalEntities;
import org.squashtest.it.datasetbuilder.entitybuilder.BuilderTestCaseWs;
import org.squashtest.it.datasetbuilder.mappers.CustomFieldMapper;
import org.squashtest.it.datasetbuilder.mappers.DatasetAndParameterMapper;
import org.squashtest.it.datasetbuilder.mappers.ProjectMapper;
import org.squashtest.it.datasetbuilder.mappers.TestStepMapper;
import org.squashtest.it.datasetbuilder.rowbuilders.AttachmentListRow;
import org.squashtest.it.datasetbuilder.rowbuilders.RequirementVersionCoverageRow;
import org.squashtest.tm.domain.customfield.BindableEntity;

public final class TestCaseLibraryNodeMapper {
    private TestCaseLibraryNodeMapper() {
        throw new AssertionError((Object)"Cannot instantiate utility class");
    }

    public static DatasetData toDatasetData(TestCaseLibraryNodeModel node, SequenceGenerator tclContentOrderSequence, ProjectMapper.ProjectData projectData) {
        Relationship relationship = new Relationship(projectData.tclId(), tclContentOrderSequence, true, null, null);
        return TestCaseLibraryNodeMapper.mapNode(node, projectData, relationship);
    }

    private static DatasetData mapNode(TestCaseLibraryNodeModel node, ProjectMapper.ProjectData projectData, Relationship relationship) {
        TestCaseLibraryNodeModel testCaseLibraryNodeModel = node;
        Objects.requireNonNull(testCaseLibraryNodeModel);
        TestCaseLibraryNodeModel testCaseLibraryNodeModel2 = testCaseLibraryNodeModel;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TestCaseFolderModel.class, StandardTestCaseModel.class, KeywordTestCaseModel.class, ScriptedTestCaseModel.class, ExploratoryTestCaseModel.class}, (Object)testCaseLibraryNodeModel2, n)) {
            case 0 -> {
                TestCaseFolderModel folder = (TestCaseFolderModel)testCaseLibraryNodeModel2;
                yield TestCaseLibraryNodeMapper.mapFolderNode(folder, projectData, relationship);
            }
            case 1 -> {
                StandardTestCaseModel standardTestCase = (StandardTestCaseModel)testCaseLibraryNodeModel2;
                yield TestCaseLibraryNodeMapper.mapStandardTestCaseNode(standardTestCase, projectData, relationship);
            }
            case 2 -> {
                KeywordTestCaseModel keywordTestCase = (KeywordTestCaseModel)testCaseLibraryNodeModel2;
                yield TestCaseLibraryNodeMapper.mapKeywordTestCase(keywordTestCase, projectData, relationship);
            }
            case 3 -> {
                ScriptedTestCaseModel scriptedTestCase = (ScriptedTestCaseModel)testCaseLibraryNodeModel2;
                yield TestCaseLibraryNodeMapper.mapScriptedTestCase(scriptedTestCase, projectData, relationship);
            }
            case 4 -> {
                ExploratoryTestCaseModel exploratoryTestCase = (ExploratoryTestCaseModel)testCaseLibraryNodeModel2;
                yield TestCaseLibraryNodeMapper.mapExploratoryTestCase(exploratoryTestCase, projectData, relationship);
            }
            default -> throw new IllegalArgumentException("Unsupported TestCaseLibraryNode type: " + node.getClass().getName());
        };
    }

    private static DatasetData mapFolderNode(TestCaseFolderModel model, ProjectMapper.ProjectData projectData, Relationship relationship) {
        Long tclnId = model.getTclnId();
        Long attachmentListId = AttachmentListRow.sequence.nextId();
        DatasetData datasetData = new DatasetData(new ArrayList<TableRow>(), new ArrayList<TableRow>());
        datasetData.addTableRowInsert(BuilderGlobalEntities.getAttachmentListTableRow(attachmentListId), BuilderTestCaseWs.getTestCaseLibraryNodeTableRow((TestCaseLibraryNodeModel)model, tclnId, attachmentListId, projectData.projectId()), BuilderTestCaseWs.getTestCaseFolderTableRow(tclnId));
        datasetData.addDatasetData(CustomFieldMapper.toDatasetData(projectData, model.getTclnId(), BindableEntity.TESTCASE_FOLDER, model.getCustomFieldValues()));
        datasetData.addTableRowInsert(TestCaseLibraryNodeMapper.mapRelationship(tclnId, relationship));
        int i = 0;
        while (i < model.getNodes().size()) {
            TestCaseLibraryNodeModel child = (TestCaseLibraryNodeModel)model.getNodes().get(i);
            Relationship childRelationship = new Relationship(relationship.testCaseLibraryId, relationship.tclContentOrderSequence, false, tclnId, i);
            datasetData.addDatasetData(TestCaseLibraryNodeMapper.mapNode(child, projectData, childRelationship));
            ++i;
        }
        return datasetData;
    }

    private static DatasetData mapStandardTestCaseNode(StandardTestCaseModel model, ProjectMapper.ProjectData projectData, Relationship relationship) {
        DatasetData datasetData = new DatasetData(new ArrayList<TableRow>(), new ArrayList<TableRow>());
        TestCaseData testCaseData = TestCaseLibraryNodeMapper.mapTestCase((TestCaseModel)model, projectData, relationship);
        datasetData.addDatasetData(testCaseData.datasetData);
        datasetData.addDatasetData(DatasetAndParameterMapper.toDatasetData(model.getParameters(), model.getDatasets(), model.getTclnId()));
        datasetData.addDatasetData(TestStepMapper.toDatasetData(model.getSteps(), model.getTclnId(), projectData, testCaseData.coverageByRequirementVersionId));
        return datasetData;
    }

    private static DatasetData mapKeywordTestCase(KeywordTestCaseModel model, ProjectMapper.ProjectData projectData, Relationship relationship) {
        DatasetData datasetData = new DatasetData(new ArrayList<TableRow>(), new ArrayList<TableRow>());
        datasetData.addDatasetData(TestCaseLibraryNodeMapper.mapTestCase((TestCaseModel)model, (ProjectMapper.ProjectData)projectData, (Relationship)relationship).datasetData);
        datasetData.addDatasetData(DatasetAndParameterMapper.toDatasetData(model.getParameters(), model.getDatasets(), model.getTclnId()));
        datasetData.addTableRowInsert(BuilderTestCaseWs.getKeywordTestCaseTableRow(model.getTclnId()));
        datasetData.addDatasetData(TestStepMapper.toDatasetData(model.getSteps(), model.getTclnId(), projectData, new HashMap<Long, Long>()));
        return datasetData;
    }

    private static DatasetData mapScriptedTestCase(ScriptedTestCaseModel model, ProjectMapper.ProjectData projectData, Relationship relationship) {
        DatasetData datasetData = new DatasetData(new ArrayList<TableRow>(), new ArrayList<TableRow>());
        datasetData.addDatasetData(TestCaseLibraryNodeMapper.mapTestCase((TestCaseModel)model, (ProjectMapper.ProjectData)projectData, (Relationship)relationship).datasetData);
        datasetData.addTableRowInsert(BuilderTestCaseWs.getScriptedTestCaseTableRow(model, model.getTclnId()));
        return datasetData;
    }

    private static DatasetData mapExploratoryTestCase(ExploratoryTestCaseModel model, ProjectMapper.ProjectData projectData, Relationship relationship) {
        DatasetData datasetData = new DatasetData(new ArrayList<TableRow>(), new ArrayList<TableRow>());
        datasetData.addDatasetData(TestCaseLibraryNodeMapper.mapTestCase((TestCaseModel)model, (ProjectMapper.ProjectData)projectData, (Relationship)relationship).datasetData);
        datasetData.addTableRowInsert(BuilderTestCaseWs.getExploratoryTestCaseTableRow(model, model.getTclnId()));
        return datasetData;
    }

    private static TestCaseData mapTestCase(TestCaseModel model, ProjectMapper.ProjectData projectData, Relationship relationship) {
        Long attachmentListId = AttachmentListRow.sequence.nextId();
        DatasetData datasetData = new DatasetData(new ArrayList<TableRow>(), new ArrayList<TableRow>());
        Long automationRequestId = TestCaseLibraryNodeMapper.mapAutomationRequest(model.getAutomationRequest(), projectData, datasetData);
        Long automatedTestId = TestCaseLibraryNodeMapper.mapAutomationRequest(model.getAutomatedTest(), datasetData);
        datasetData.addTableRowInsert(BuilderGlobalEntities.getAttachmentListTableRow(attachmentListId), BuilderTestCaseWs.getTestCaseLibraryNodeTableRow((TestCaseLibraryNodeModel)model, model.getTclnId(), attachmentListId, projectData.projectId()), BuilderTestCaseWs.getTestCaseTableRow(model, model.getTclnId(), projectData.defaultNatureItemId(), projectData.defaultTypeItemId(), null, null));
        datasetData.addTableRowUpdate(BuilderTestCaseWs.getTestCaseTableRow(model, model.getTclnId(), projectData.defaultNatureItemId(), projectData.defaultTypeItemId(), automationRequestId, automatedTestId));
        model.getMilestoneIds().forEach(milestoneId -> datasetData.addTableRowInsert(BuilderTestCaseWs.getMilestoneTestCaseTableRow(milestoneId, model.getTclnId())));
        datasetData.addDatasetData(CustomFieldMapper.toDatasetData(projectData, model.getTclnId(), BindableEntity.TEST_CASE, model.getCustomFieldValues()));
        datasetData.addTableRowInsert(TestCaseLibraryNodeMapper.mapRelationship(model.getTclnId(), relationship));
        Map<Long, Long> coverageByRequirementVersionId = model.getRequirementVersionIds().stream().collect(Collectors.toMap(requirementVersionId -> requirementVersionId, requirementVersionId -> {
            Long requirementVersionCoverageId = RequirementVersionCoverageRow.sequence.nextId();
            datasetData.addTableRowInsert(BuilderTestCaseWs.getRequirementVersionCoverage(requirementVersionCoverageId, requirementVersionId, model.getTclnId()));
            return requirementVersionCoverageId;
        }));
        return new TestCaseData(datasetData, coverageByRequirementVersionId);
    }

    public static Long mapAutomationRequest(AutomationRequestModel model, ProjectMapper.ProjectData projectData, DatasetData datasetData) {
        if (Objects.isNull(model)) {
            return null;
        }
        Long automationRequestId = model.getId();
        datasetData.addTableRowInsert(BuilderTestCaseWs.getAutomationRequestTableRow(model, projectData.projectId()), BuilderTestCaseWs.getAutomationRequestLibraryContentTableRow(automationRequestId, projectData.arlId()));
        return automationRequestId;
    }

    public static Long mapAutomationRequest(AutomatedTestModel model, DatasetData datasetData) {
        if (Objects.isNull(model)) {
            return null;
        }
        Long automatedTest = model.getId();
        datasetData.addTableRowInsert(BuilderTestCaseWs.getAutomatedTest(model));
        return automatedTest;
    }

    private static TableRow mapRelationship(Long tclnId, Relationship relationship) {
        if (relationship.atRoot) {
            return BuilderTestCaseWs.getRelationshipToLibrary(relationship.testCaseLibraryId, tclnId, relationship.tclContentOrderSequence.getIdAndIncrement());
        }
        Objects.requireNonNull(relationship.parentId);
        Objects.requireNonNull(relationship.order);
        return BuilderTestCaseWs.getRelationshipToTclnNode(relationship.parentId, tclnId, relationship.order);
    }

    private record Relationship(Long testCaseLibraryId, SequenceGenerator tclContentOrderSequence, boolean atRoot, Long parentId, Integer order) {
    }

    private record TestCaseData(DatasetData datasetData, Map<Long, Long> coverageByRequirementVersionId) {
    }
}

