/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.it.datasetbuilder.mappers;

import java.lang.runtime.SwitchBootstraps;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.squashtest.it.datasetbuilder.DatasetData;
import org.squashtest.it.datasetbuilder.SequenceGenerator;
import org.squashtest.it.datasetbuilder.TableRow;
import org.squashtest.it.datasetbuilder.api.model.ActionTestStepModel;
import org.squashtest.it.datasetbuilder.api.model.CallTestStepModel;
import org.squashtest.it.datasetbuilder.api.model.DatasetModel;
import org.squashtest.it.datasetbuilder.api.model.DenormalizedValueModel;
import org.squashtest.it.datasetbuilder.api.model.ExecutionModel;
import org.squashtest.it.datasetbuilder.api.model.ExecutionStepModel;
import org.squashtest.it.datasetbuilder.api.model.ExploratoryEventModel;
import org.squashtest.it.datasetbuilder.api.model.ExploratoryExecutionModel;
import org.squashtest.it.datasetbuilder.api.model.ExploratoryTestCaseModel;
import org.squashtest.it.datasetbuilder.api.model.KeywordTestCaseModel;
import org.squashtest.it.datasetbuilder.api.model.KeywordTestStepModel;
import org.squashtest.it.datasetbuilder.api.model.ManualExecutionModel;
import org.squashtest.it.datasetbuilder.api.model.ManualExecutionStepModel;
import org.squashtest.it.datasetbuilder.api.model.ScriptedTestCaseModel;
import org.squashtest.it.datasetbuilder.api.model.StandardTestCaseModel;
import org.squashtest.it.datasetbuilder.api.model.TestCaseModel;
import org.squashtest.it.datasetbuilder.api.model.TestPlanItemModel;
import org.squashtest.it.datasetbuilder.api.model.TestStepModel;
import org.squashtest.it.datasetbuilder.entitybuilder.BuilderAdminWsEntities;
import org.squashtest.it.datasetbuilder.entitybuilder.BuilderExecutionWs;
import org.squashtest.it.datasetbuilder.entitybuilder.BuilderGlobalEntities;
import org.squashtest.it.datasetbuilder.mappers.CustomFieldMapper;
import org.squashtest.it.datasetbuilder.mappers.ProjectMapper;
import org.squashtest.it.datasetbuilder.parser.DateParser;
import org.squashtest.it.datasetbuilder.rowbuilders.AttachmentListRow;
import org.squashtest.it.datasetbuilder.rowbuilders.DenormalizedFieldValueRow;
import org.squashtest.it.datasetbuilder.rowbuilders.ExecutionRow;
import org.squashtest.it.datasetbuilder.rowbuilders.ExecutionStepRow;
import org.squashtest.it.datasetbuilder.rowbuilders.ExploratoryExecutionEventRow;
import org.squashtest.it.datasetbuilder.rowbuilders.SessionNoteRow;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolderType;

public final class ExecutionMapper {
    private ExecutionMapper() {
        throw new AssertionError((Object)"Cannot instantiate utility class");
    }

    private static String getBaseErrorMessage(Long executionOrder, Long tpiId) {
        Object[] objectArray = new Object[2];
        executionOrder = executionOrder + 1L;
        objectArray[0] = executionOrder;
        objectArray[1] = tpiId;
        return String.format("TPI's #%s execution with id %s", objectArray);
    }

    public static DatasetData toDatasetData(ExecutionModel node, TestPlanItemModel tpiModel, Long executionOrder, ProjectMapper.ProjectData projectData) {
        ExecutionModel executionModel = node;
        Objects.requireNonNull(executionModel);
        ExecutionModel executionModel2 = executionModel;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ManualExecutionModel.class, ExploratoryExecutionModel.class}, (Object)executionModel2, n)) {
            case 0 -> {
                ManualExecutionModel manualExecutionModel = (ManualExecutionModel)executionModel2;
                yield ExecutionMapper.mapManualExecution(manualExecutionModel, tpiModel, executionOrder, projectData);
            }
            case 1 -> {
                ExploratoryExecutionModel exploratoryExecutionModel = (ExploratoryExecutionModel)executionModel2;
                yield ExecutionMapper.mapExploratoryExecution(exploratoryExecutionModel, tpiModel, executionOrder, projectData);
            }
            default -> throw new IllegalArgumentException("Unsupported Execution type: " + node.getClass().getName());
        };
    }

    private static DatasetData mapExecution(ExecutionModel model, TestCaseModel tcModel, TestPlanItemModel tpiModel, Long executionId, String datasetLabel, Long executionOrder, ProjectMapper.ProjectData projectData) {
        DatasetData datasetData = new DatasetData(new ArrayList<TableRow>(), new ArrayList<TableRow>());
        Long attachmentListId = AttachmentListRow.sequence.nextId();
        datasetData.addTableRowInsert(BuilderGlobalEntities.getAttachmentListTableRow(attachmentListId), BuilderExecutionWs.getExecutionTableRow(model, executionId, executionOrder, attachmentListId, tpiModel, tcModel, datasetLabel));
        datasetData.addDatasetData(CustomFieldMapper.toDatasetData(projectData, executionId, BindableEntity.EXECUTION, model.getCustomFieldValues()));
        datasetData.addTableRowInsert(ExecutionMapper.getDenormalizedFieldValues(projectData, tpiModel.getDeleted(), tpiModel.getTclnId(), BindableEntity.TEST_CASE, model.getDenormalizedValues(), executionId, DenormalizedFieldHolderType.EXECUTION));
        return datasetData;
    }

    private static DatasetData mapExploratoryExecution(ExploratoryExecutionModel model, TestPlanItemModel tpiModel, Long executionOrder, ProjectMapper.ProjectData projectData) {
        ExploratoryTestCaseModel exploratoryTestCaseModel;
        DatasetData datasetData = new DatasetData(new ArrayList<TableRow>(), new ArrayList<TableRow>());
        Long executionId = ExecutionRow.sequence.nextId();
        TestCaseModel testCaseModel = ExecutionMapper.getTestCaseModel(tpiModel.getTpiId(), executionOrder, tpiModel.getTclnId(), projectData);
        if (!(testCaseModel instanceof ExploratoryTestCaseModel)) {
            throw new IllegalArgumentException(String.format("%s : Test case with id %s is not an exploratory test case", ExecutionMapper.getBaseErrorMessage(executionOrder, tpiModel.getTpiId()), tpiModel.getTclnId()));
        }
        ExploratoryTestCaseModel tcModel = exploratoryTestCaseModel = (ExploratoryTestCaseModel)testCaseModel;
        datasetData.addDatasetData(ExecutionMapper.mapExecution((ExecutionModel)model, (TestCaseModel)tcModel, tpiModel, executionId, null, executionOrder, projectData));
        datasetData.addTableRowInsert(BuilderExecutionWs.getExploratoryExecutionTableRow(model, executionId));
        DateParser dateParser = new DateParser(ExecutionMapper.getBaseErrorMessage(executionOrder, tpiModel.getTpiId()), "eventDate");
        Map<LocalDateTime, ExploratoryEventModel> exploratoryEventModelByEventDate = dateParser.modelByDates(model.getEvents(), ExploratoryEventModel::getEventDate);
        exploratoryEventModelByEventDate.forEach((date, eventModel) -> {
            Long eventId = ExploratoryExecutionEventRow.sequence.nextId();
            datasetData.addTableRowInsert(BuilderExecutionWs.getExploratoryExecutionEventTableRow(eventModel, eventId, executionId, date.format(DateParser.dateTimeFormat)));
        });
        SequenceGenerator noteOrderGenerator = new SequenceGenerator();
        model.getSessionNotes().forEach(noteModel -> {
            Long attachmentListId = AttachmentListRow.sequence.nextId();
            Long noteId = SessionNoteRow.sequence.nextId();
            datasetData.addTableRowInsert(BuilderGlobalEntities.getAttachmentListTableRow(attachmentListId), BuilderExecutionWs.getSessionNodeTableRow(noteModel, noteId, executionId, attachmentListId, noteOrderGenerator.getIdAndIncrement()));
        });
        return datasetData;
    }

    private static DatasetData mapManualExecution(ManualExecutionModel model, TestPlanItemModel tpiModel, Long executionOrder, ProjectMapper.ProjectData projectData) {
        DatasetData datasetData = new DatasetData(new ArrayList<TableRow>(), new ArrayList<TableRow>());
        Long executionId = ExecutionRow.sequence.nextId();
        TestCaseModel tcModel = ExecutionMapper.getTestCaseModel(tpiModel.getTpiId(), executionOrder, tpiModel.getTclnId(), projectData);
        String datasetLabel = ExecutionMapper.getDatasetLabel(tpiModel.getDatasetId(), tcModel, ExecutionMapper.getBaseErrorMessage(executionOrder, tpiModel.getTpiId()));
        datasetData.addDatasetData(ExecutionMapper.mapExecution((ExecutionModel)model, tcModel, tpiModel, executionId, datasetLabel, executionOrder, projectData));
        datasetData.addDatasetData(ExecutionMapper.mapManualExecutionStep(model.getExecutionStep(), tpiModel, executionOrder, executionId, tcModel, projectData));
        return datasetData;
    }

    private static DatasetData mapManualExecutionStep(List<ManualExecutionStepModel> executionStepModels, TestPlanItemModel tpiModel, Long executionOrder, Long executionId, TestCaseModel tcModel, ProjectMapper.ProjectData projectData) {
        DatasetData datasetData = new DatasetData(new ArrayList<TableRow>(), new ArrayList<TableRow>());
        TestCaseModel testCaseModel = tcModel;
        Objects.requireNonNull(testCaseModel);
        TestCaseModel testCaseModel2 = testCaseModel;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StandardTestCaseModel.class, KeywordTestCaseModel.class, ScriptedTestCaseModel.class, ExploratoryTestCaseModel.class}, (Object)testCaseModel2, n)) {
            case 0: {
                StandardTestCaseModel standardTestCaseModel = (StandardTestCaseModel)testCaseModel2;
                datasetData.addDatasetData(ExecutionMapper.mapManualExecution(executionStepModels, tpiModel, (TestCaseModel)standardTestCaseModel, executionOrder, executionId, standardTestCaseModel.getSteps(), projectData));
                break;
            }
            case 1: {
                KeywordTestCaseModel keywordTestCaseModel = (KeywordTestCaseModel)testCaseModel2;
                datasetData.addTableRowInsert(BuilderExecutionWs.getKeywordExecutionTableRow(executionId));
                datasetData.addDatasetData(ExecutionMapper.mapManualExecution(executionStepModels, tpiModel, (TestCaseModel)keywordTestCaseModel, executionOrder, executionId, keywordTestCaseModel.getSteps(), projectData));
                break;
            }
            case 2: {
                ScriptedTestCaseModel scriptedTestCaseModel = (ScriptedTestCaseModel)testCaseModel2;
                ManualExecutionStepModel manualExecutionStepModel = executionStepModels.isEmpty() ? new ManualExecutionStepModel() : executionStepModels.getFirst();
                datasetData.addTableRowInsert(BuilderExecutionWs.getScriptedExecutionTableRow(executionId, scriptedTestCaseModel.getName()));
                datasetData.addDatasetData(ExecutionMapper.getManualExecutionsStepsTableRows(manualExecutionStepModel, tpiModel, (TestCaseModel)scriptedTestCaseModel, executionId, 0L, new ManualExecutionStepData(null, scriptedTestCaseModel.getScript(), ""), projectData));
                break;
            }
            case 3: {
                ExploratoryTestCaseModel ignored = (ExploratoryTestCaseModel)testCaseModel2;
                throw new IllegalStateException(String.format("%s : To add executions to exploratory tests, use %s", ExecutionMapper.getBaseErrorMessage(executionOrder, tpiModel.getTpiId()), ExploratoryExecutionModel.class.getSimpleName()));
            }
            default: {
                throw new IllegalStateException(String.format("%s : Unsupported manual execution step type : %s", ExecutionMapper.getBaseErrorMessage(executionOrder, tpiModel.getTpiId()), tcModel.getClass().getName()));
            }
        }
        return datasetData;
    }

    private static <T extends TestStepModel> DatasetData mapManualExecution(List<ManualExecutionStepModel> executionStepModels, TestPlanItemModel tpiModel, TestCaseModel tcModel, Long executionOrder, Long executionId, List<T> testStepModels, ProjectMapper.ProjectData projectData) {
        DatasetData datasetData = new DatasetData(new ArrayList<TableRow>(), new ArrayList<TableRow>());
        ArrayList<Long> cyclicTestCaseGuard = new ArrayList<Long>();
        List<ManualExecutionStepData> manualExecutionStepDatas = ExecutionMapper.getManualExecutionStepData(tpiModel.getTpiId(), executionOrder, testStepModels, tcModel.getTclnId(), projectData.testCaseModelByTclnId(), cyclicTestCaseGuard);
        ArrayList<ManualExecutionStepModel> consumeExecutionStepModels = new ArrayList<ManualExecutionStepModel>(executionStepModels);
        SequenceGenerator executionStepOrderGenerator = new SequenceGenerator();
        for (ManualExecutionStepData manualExecutionStepData : manualExecutionStepDatas) {
            ManualExecutionStepModel manualExecutionStepModel = consumeExecutionStepModels.stream().filter(model -> model.getStepId().equals(manualExecutionStepData.testStepId())).findFirst().orElse(new ManualExecutionStepModel());
            datasetData.addDatasetData(ExecutionMapper.getManualExecutionsStepsTableRows(manualExecutionStepModel, tpiModel, tcModel, executionId, executionStepOrderGenerator.getIdAndIncrement(), manualExecutionStepData, projectData));
        }
        return datasetData;
    }

    private static DatasetData getManualExecutionsStepsTableRows(ManualExecutionStepModel model, TestPlanItemModel tpiModel, TestCaseModel tcModel, Long executionId, Long executionStepOrder, ManualExecutionStepData manualExecutionStepData, ProjectMapper.ProjectData projectData) {
        DatasetData datasetData = new DatasetData(new ArrayList<TableRow>(), new ArrayList<TableRow>());
        Long attachmentExecutionStep = AttachmentListRow.sequence.nextId();
        Long executionStepId = ExecutionStepRow.sequence.nextId();
        Long referenceStepId = null;
        if (!tpiModel.getDeleted()) {
            referenceStepId = manualExecutionStepData.testStepId();
        }
        datasetData.addTableRowInsert(BuilderGlobalEntities.getAttachmentListTableRow(attachmentExecutionStep), BuilderExecutionWs.getExecutionStepTableRow((ExecutionStepModel)model, executionStepId, referenceStepId, attachmentExecutionStep, manualExecutionStepData.action(), manualExecutionStepData.expectedResult()), BuilderExecutionWs.getExecutionExecutionStepsRow(executionId, executionStepId, executionStepOrder));
        datasetData.addDatasetData(CustomFieldMapper.toDatasetData(projectData, executionStepId, BindableEntity.EXECUTION_STEP, model.getCustomFieldValues()));
        if (tcModel instanceof StandardTestCaseModel) {
            datasetData.addTableRowInsert(ExecutionMapper.getDenormalizedFieldValues(projectData, tpiModel.getDeleted(), manualExecutionStepData.testStepId(), BindableEntity.TEST_STEP, model.getDenormalizedValues(), executionStepId, DenormalizedFieldHolderType.EXECUTION_STEP));
        }
        return datasetData;
    }

    private static List<TableRow> getDenormalizedFieldValues(ProjectMapper.ProjectData projectData, boolean isDeleted, Long referenceId, BindableEntity bindableEntity, List<DenormalizedValueModel> denormalizedValueModels, Long holderId, DenormalizedFieldHolderType holderType) {
        ArrayList<TableRow> tableRows = new ArrayList<TableRow>();
        SequenceGenerator positionSequence = new SequenceGenerator();
        Map dvDataByCufId = projectData.denormalizedDataByBindableEntity().getOrDefault(bindableEntity, Map.of()).getOrDefault(referenceId, List.of()).stream().collect(Collectors.toMap(dvData -> dvData.customFieldValueData().cfId(), Function.identity()));
        denormalizedValueModels.forEach(dvModel -> {
            DenormalizedValueData denormalizedValueData;
            if (dvDataByCufId.containsKey(dvModel.getCufId())) {
                ProjectMapper.DenormalizedData dvData = (ProjectMapper.DenormalizedData)dvDataByCufId.get(dvModel.getCufId());
                denormalizedValueData = new DenormalizedValueData((DenormalizedValueModel)dvModel, dvData, holderId, holderType, isDeleted);
                dvDataByCufId.remove(dvModel.getCufId());
            } else {
                denormalizedValueData = new DenormalizedValueData((DenormalizedValueModel)dvModel, null, holderId, holderType, isDeleted);
            }
            tableRows.add(ExecutionMapper.getDenormalizedFieldValue(denormalizedValueData, positionSequence));
        });
        dvDataByCufId.values().forEach(dvData -> {
            boolean bl2 = tableRows.add(ExecutionMapper.getDenormalizedFieldValue(new DenormalizedValueData((ProjectMapper.DenormalizedData)dvData, holderId, holderType, isDeleted), positionSequence));
        });
        return tableRows;
    }

    private static TableRow getDenormalizedFieldValue(DenormalizedValueData denormalizedValueData, SequenceGenerator positionGenerator) {
        Long dfvId = DenormalizedFieldValueRow.sequence.nextId();
        Long position = positionGenerator.getIdAndIncrement();
        return BuilderAdminWsEntities.getDenormalizedFieldValueTableRow(dfvId, denormalizedValueData, position);
    }

    private static <T extends TestStepModel> List<ManualExecutionStepData> getManualExecutionStepData(Long tpiId, Long executionOrder, List<T> testStepModels, Long tclnId, Map<Long, TestCaseModel> testCaseModelByTclnId, List<Long> cyclicTestCaseGuard) {
        ArrayList<ManualExecutionStepData> executionStepDatas = new ArrayList<ManualExecutionStepData>();
        for (TestStepModel step : testStepModels) {
            TestStepModel testStepModel;
            cyclicTestCaseGuard.add(tclnId);
            Objects.requireNonNull(step);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ActionTestStepModel.class, CallTestStepModel.class, KeywordTestStepModel.class}, (Object)testStepModel, n)) {
                case 0: {
                    ActionTestStepModel actionTestStepModel = (ActionTestStepModel)testStepModel;
                    executionStepDatas.add(new ManualExecutionStepData(actionTestStepModel.getStepId(), actionTestStepModel.getAction(), actionTestStepModel.getExpectedResult()));
                    break;
                }
                case 1: {
                    CallTestStepModel callTestStepModel = (CallTestStepModel)testStepModel;
                    executionStepDatas.addAll(ExecutionMapper.mapCallTestStep(tpiId, executionOrder, callTestStepModel, tclnId, testCaseModelByTclnId, cyclicTestCaseGuard));
                    break;
                }
                case 2: {
                    KeywordTestStepModel keywordTestStepModel = (KeywordTestStepModel)testStepModel;
                    String keywordAction = String.format("%s %s", keywordTestStepModel.getKeyword().getLabel(), keywordTestStepModel.getActionWord().getWords());
                    executionStepDatas.add(new ManualExecutionStepData(keywordTestStepModel.getStepId(), keywordAction, ""));
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("%s : Unsupported step : %s", ExecutionMapper.getBaseErrorMessage(executionOrder, tpiId), step.getClass().getName()));
                }
            }
        }
        return executionStepDatas;
    }

    private static List<ManualExecutionStepData> mapCallTestStep(Long tpiId, Long executionOrder, CallTestStepModel callTestStepModel, Long tclnId, Map<Long, TestCaseModel> testCaseModelByTclnId, List<Long> cyclicTestCaseGuard) {
        if (testCaseModelByTclnId.containsKey(callTestStepModel.getCalledTestCaseId())) {
            TestCaseModel calledTestCaseModel = testCaseModelByTclnId.get(callTestStepModel.getCalledTestCaseId());
            if (cyclicTestCaseGuard.contains(calledTestCaseModel.getTclnId())) {
                throw new IllegalArgumentException(String.format("%s : cyclic test case call for test case with id %s", ExecutionMapper.getBaseErrorMessage(executionOrder, tpiId), calledTestCaseModel.getTclnId()));
            }
            if (calledTestCaseModel instanceof StandardTestCaseModel) {
                StandardTestCaseModel standardTestCaseModel = (StandardTestCaseModel)calledTestCaseModel;
                return ExecutionMapper.getManualExecutionStepData(tpiId, executionOrder, standardTestCaseModel.getSteps(), tclnId, testCaseModelByTclnId, cyclicTestCaseGuard);
            }
            throw new IllegalArgumentException(String.format("%s : called test case with id %s is not a StandardTestCaseModel", ExecutionMapper.getBaseErrorMessage(executionOrder, tpiId), callTestStepModel.getCalledTestCaseId()));
        }
        throw new IllegalArgumentException(String.format("%s : called test case with id %s is not found", ExecutionMapper.getBaseErrorMessage(executionOrder, tpiId), callTestStepModel.getCalledTestCaseId()));
    }

    private static TestCaseModel getTestCaseModel(Long tpiId, Long executionOrder, Long tclnId, ProjectMapper.ProjectData projectData) {
        Map<Long, TestCaseModel> testCaseModelByTclnId = projectData.testCaseModelByTclnId();
        if (testCaseModelByTclnId.containsKey(tclnId)) {
            return testCaseModelByTclnId.get(tclnId);
        }
        throw new IllegalArgumentException(String.format("%s : Test case with id %s is missing", ExecutionMapper.getBaseErrorMessage(executionOrder, tpiId), tclnId));
    }

    private static String getDatasetLabel(Long datasetId, TestCaseModel tcModel, String baseErrorMessage) {
        if (datasetId == null) {
            return null;
        }
        TestCaseModel testCaseModel = tcModel;
        Objects.requireNonNull(testCaseModel);
        TestCaseModel testCaseModel2 = testCaseModel;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StandardTestCaseModel.class, KeywordTestCaseModel.class}, (Object)testCaseModel2, n)) {
            case 0 -> {
                StandardTestCaseModel standardTestCaseModel = (StandardTestCaseModel)testCaseModel2;
                yield ExecutionMapper.getDatasetLabel(standardTestCaseModel.getDatasets(), datasetId);
            }
            case 1 -> {
                KeywordTestCaseModel keywordTestCaseModel = (KeywordTestCaseModel)testCaseModel2;
                yield ExecutionMapper.getDatasetLabel(keywordTestCaseModel.getDatasets(), datasetId);
            }
            default -> throw new IllegalArgumentException(String.format("%s : Test case with id %s and type %s cannot have a dataset", baseErrorMessage, tcModel.getTclnId(), tcModel.getClass().getName()));
        };
    }

    private static String getDatasetLabel(List<DatasetModel> datasetModels, Long datasetId) {
        if (datasetId == null) {
            return null;
        }
        return datasetModels.stream().filter(dataset -> dataset.getDatasetId().equals(datasetId)).map(DatasetModel::getName).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Dataset with id %s not found in test case", datasetId)));
    }

    public record DenormalizedValueData(Long cfvId, InputType inputType, String code, String label, Object value, Long holderId, DenormalizedFieldHolderType holderType, boolean deleted) {
        private final Long cfvId;

        public DenormalizedValueData(DenormalizedValueModel dvModel, Long cfvId, Long holderId, DenormalizedFieldHolderType holderType, boolean deleted) {
            this(cfvId, dvModel.getInputType(), dvModel.getCode(), dvModel.getLabel(), dvModel.getValue(), holderId, holderType, deleted);
        }

        public DenormalizedValueData(DenormalizedValueModel dvModel, ProjectMapper.DenormalizedData dvData, Long holderId, DenormalizedFieldHolderType holderType, boolean deleted) {
            this(dvData.cfvId(), Optional.ofNullable(dvModel.getInputType()).orElse(dvData.customFieldValueData().inputType()), Optional.ofNullable(dvModel.getCode()).orElse(dvData.customFieldValueData().code()), Optional.ofNullable(dvModel.getLabel()).orElse(dvData.customFieldValueData().label()), Optional.ofNullable(dvModel.getValue()).orElse(dvData.customFieldValueData().value()), holderId, holderType, deleted);
        }

        public DenormalizedValueData(ProjectMapper.DenormalizedData dvData, Long holderId, DenormalizedFieldHolderType holderType, boolean deleted) {
            this(dvData.cfvId(), dvData.customFieldValueData().inputType(), dvData.customFieldValueData().code(), dvData.customFieldValueData().label(), dvData.customFieldValueData().value(), holderId, holderType, deleted);
        }

        public Long cfvId() {
            if (this.deleted) {
                return null;
            }
            return this.cfvId;
        }
    }

    private record ManualExecutionStepData(Long testStepId, String action, String expectedResult) {
    }
}

