/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.it.datasetbuilder.parser;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class DateParser {
    public static final DateTimeFormatter dateTimeFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final Pattern pattern = Pattern.compile("^(\\d{4}-\\d{2}-\\d{2})([T\\s])?(\\d{2}:\\d{2}:\\d{2})?");
    private final String entityBaseErrorMessage;
    private final String fieldName;

    public DateParser(String entityBaseErrorMessage, String fieldName) {
        this.entityBaseErrorMessage = entityBaseErrorMessage;
        this.fieldName = fieldName;
    }

    public LocalDateTime parse(String date) {
        Matcher matcher = pattern.matcher(date);
        if (matcher.matches()) {
            String datePart = matcher.group(1);
            String timePart = matcher.group(3) != null ? matcher.group(3) : "00:00:00";
            return LocalDateTime.parse(datePart + "T" + timePart, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        }
        throw new IllegalArgumentException(String.format("%s: %s is not a valid date format for field %s. At least YYYY-MM-DD is expected.", this.entityBaseErrorMessage, date, this.fieldName));
    }

    public <T> Map<LocalDateTime, T> modelByDates(List<T> models, Function<T, String> dateExtractor) {
        LinkedHashMap modelByDate = new LinkedHashMap();
        models.stream().collect(Collectors.groupingBy(model -> this.parse((String)dateExtractor.apply(model)), Collectors.mapping(event -> event, Collectors.toList()))).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            long plusSeconds = 0L;
            for (Object model : (List)entry.getValue()) {
                modelByDate.put(((LocalDateTime)entry.getKey()).plusSeconds(plusSeconds), model);
                ++plusSeconds;
            }
        });
        return modelByDate;
    }
}

