/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.it.datasetbuilder.mappers;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.squashtest.it.datasetbuilder.DatasetData;
import org.squashtest.it.datasetbuilder.SequenceGenerator;
import org.squashtest.it.datasetbuilder.TableRow;
import org.squashtest.it.datasetbuilder.api.model.RequirementFolderModel;
import org.squashtest.it.datasetbuilder.api.model.RequirementLibraryNodeModel;
import org.squashtest.it.datasetbuilder.api.model.RequirementModel;
import org.squashtest.it.datasetbuilder.api.model.RequirementVersionModel;
import org.squashtest.it.datasetbuilder.entitybuilder.BuilderGlobalEntities;
import org.squashtest.it.datasetbuilder.entitybuilder.BuilderRequirementWs;
import org.squashtest.it.datasetbuilder.mappers.CustomFieldMapper;
import org.squashtest.it.datasetbuilder.mappers.ProjectMapper;
import org.squashtest.it.datasetbuilder.rowbuilders.AttachmentListRow;
import org.squashtest.tm.domain.customfield.BindableEntity;

public final class RequirementLibraryNodeMapper {
    private RequirementLibraryNodeMapper() {
        throw new AssertionError((Object)"Cannot instantiate utility class");
    }

    public static DatasetData toDatasetData(RequirementLibraryNodeModel node, SequenceGenerator rlContentOrderSequence, ProjectMapper.ProjectData projectData) {
        DatasetData datasetData = new DatasetData(new ArrayList<TableRow>(), new ArrayList<TableRow>());
        Relationship relationship = new Relationship(projectData.rlId(), rlContentOrderSequence, true, null, null);
        datasetData.addDatasetData(RequirementLibraryNodeMapper.mapNode(node, projectData, relationship));
        return datasetData;
    }

    private static DatasetData mapNode(RequirementLibraryNodeModel node, ProjectMapper.ProjectData projectData, Relationship relationship) {
        RequirementLibraryNodeModel requirementLibraryNodeModel = node;
        Objects.requireNonNull(requirementLibraryNodeModel);
        RequirementLibraryNodeModel requirementLibraryNodeModel2 = requirementLibraryNodeModel;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RequirementFolderModel.class, RequirementModel.class}, (Object)requirementLibraryNodeModel2, n)) {
            case 0 -> {
                RequirementFolderModel folder = (RequirementFolderModel)requirementLibraryNodeModel2;
                yield RequirementLibraryNodeMapper.mapFolderNode(folder, projectData, relationship);
            }
            case 1 -> {
                RequirementModel requirement = (RequirementModel)requirementLibraryNodeModel2;
                yield RequirementLibraryNodeMapper.mapRequirementNode(requirement, projectData, relationship);
            }
            default -> throw new IllegalArgumentException("Unsupported RequirementLibraryNode type: " + node.getClass().getName());
        };
    }

    private static DatasetData mapFolderNode(RequirementFolderModel model, ProjectMapper.ProjectData projectData, Relationship relationship) {
        Long rlnId = model.getRlnId();
        Long resId = model.getResId();
        Long attachmentListId = AttachmentListRow.sequence.nextId();
        DatasetData datasetData = new DatasetData(new ArrayList<TableRow>(), new ArrayList<TableRow>());
        datasetData.addTableRowInsert(BuilderGlobalEntities.getAttachmentListTableRow(attachmentListId), BuilderRequirementWs.getRequirementLibraryNodeTableRow((RequirementLibraryNodeModel)model, rlnId, projectData.projectId()), BuilderRequirementWs.getResourceTableRow((RequirementLibraryNodeModel)model, resId, model.getName(), model.getDescription(), attachmentListId), BuilderRequirementWs.getSimpleResourceTableRow(resId), BuilderRequirementWs.getRequirementFolderTableRow(rlnId, resId));
        datasetData.addDatasetData(CustomFieldMapper.toDatasetData(projectData, rlnId, BindableEntity.REQUIREMENT_FOLDER, model.getCustomFieldValues()));
        datasetData.addDatasetData(RequirementLibraryNodeMapper.mapChildElement(rlnId, model.getNodes(), relationship, projectData));
        return datasetData;
    }

    private static DatasetData mapRequirementNode(RequirementModel model, ProjectMapper.ProjectData projectData, Relationship relationship) {
        Long rlnId = model.getRlnId();
        DatasetData datasetData = new DatasetData(new ArrayList<TableRow>(), new ArrayList<TableRow>());
        datasetData.addTableRowInsert(BuilderRequirementWs.getRequirementLibraryNodeTableRow((RequirementLibraryNodeModel)model, rlnId, projectData.projectId()), BuilderRequirementWs.getRequirementTableRow(rlnId, null, null));
        Long resId = null;
        int i = 0;
        while (i < model.getRequirementVersions().size()) {
            resId = ((RequirementVersionModel)model.getRequirementVersions().get(i)).getResId();
            datasetData.addTableRowInsert(RequirementLibraryNodeMapper.mapRequirementVersions((RequirementVersionModel)model.getRequirementVersions().get(i), projectData, rlnId, resId, i));
            datasetData.addDatasetData(CustomFieldMapper.toDatasetData(projectData, resId, BindableEntity.REQUIREMENT_VERSION, ((RequirementVersionModel)model.getRequirementVersions().get(i)).getCustomFieldValues()));
            ++i;
        }
        datasetData.addTableRowUpdate(BuilderRequirementWs.getRequirementTableRow(rlnId, resId, model.getHighLevelRequirementId()));
        if (model.getHighLevelRequirement()) {
            datasetData.addTableRowInsert(BuilderRequirementWs.getHighLevelRequirementTableRow(rlnId));
        }
        datasetData.addDatasetData(RequirementLibraryNodeMapper.mapChildElement(rlnId, model.getNodes(), relationship, projectData));
        return datasetData;
    }

    private static <T extends RequirementLibraryNodeModel> DatasetData mapChildElement(Long rlnId, List<T> nodes, Relationship relationship, ProjectMapper.ProjectData projectData) {
        DatasetData datasetData = new DatasetData(new ArrayList<TableRow>(), new ArrayList<TableRow>());
        datasetData.addTableRowInsert(RequirementLibraryNodeMapper.mapRelationship(rlnId, relationship));
        int i = 0;
        while (i < nodes.size()) {
            Relationship relationshipChild = new Relationship(relationship.requirementLibraryId, relationship.rlContentOrderSequence, false, rlnId, i);
            datasetData.addDatasetData(RequirementLibraryNodeMapper.mapNode((RequirementLibraryNodeModel)nodes.get(i), projectData, relationshipChild));
            ++i;
        }
        return datasetData;
    }

    private static List<TableRow> mapRequirementVersions(RequirementVersionModel model, ProjectMapper.ProjectData projectData, Long rlnId, Long resId, int versionNumber) {
        Long attachmentListId = AttachmentListRow.sequence.nextId();
        ArrayList<TableRow> tableRows = new ArrayList<TableRow>();
        tableRows.add(BuilderGlobalEntities.getAttachmentListTableRow(attachmentListId));
        tableRows.add(BuilderRequirementWs.getResourceTableRow(model, resId, model.getName(), model.getDescription(), attachmentListId));
        tableRows.add(BuilderRequirementWs.getRequirementVersionTableRow(model, resId, rlnId, projectData.defaultCategoryItemId(), versionNumber));
        tableRows.addAll(model.getMilestoneIds().stream().map(milestoneId -> BuilderRequirementWs.getMilestoneReqVersionTableRow(milestoneId, resId)).toList());
        return tableRows;
    }

    private static TableRow mapRelationship(Long rlnId, Relationship relationship) {
        if (relationship.atRoot) {
            return BuilderRequirementWs.getRelationshipToLibrary(relationship.requirementLibraryId, rlnId, relationship.rlContentOrderSequence.getIdAndIncrement());
        }
        Objects.requireNonNull(relationship.parentId);
        Objects.requireNonNull(relationship.order);
        return BuilderRequirementWs.getRelationshipToRlnNode(relationship.parentId, rlnId, relationship.order);
    }

    private record Relationship(long requirementLibraryId, SequenceGenerator rlContentOrderSequence, boolean atRoot, Long parentId, Integer order) {
    }
}

