/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.squash.automation.tm.testplan.library.model;

import java.io.UnsupportedEncodingException;
import java.util.Base64;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.squash.automation.tm.testplan.library.model.Credentials;
import org.squashtest.squash.automation.tm.testplan.library.model.InvalidTestPlanException;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum CredentialsType {
    BASIC_AUTH("password"){

        @Override
        public void usernameCheck(String userName) {
            Objects.requireNonNull(userName, "User name is mandatory for login/password pair");
        }

        @Override
        public Credentials buildCredentials(String credentialsData) {
            try {
                String username = credentialsData.split(":")[0];
                LOGGER.debug("Building basic_auth credential for username {}", (Object)username);
                String secret = new String(Base64.getDecoder().decode(credentialsData.split(":")[1].trim()), "UTF-8");
                return new Credentials(this, username, secret);
            }
            catch (UnsupportedEncodingException ex) {
                throw new InvalidTestPlanException("Invalid credentials", ex);
            }
        }

        @Override
        public String toString(String username) {
            return this.name() + "(" + username + ")";
        }
    }
    ,
    TOKEN_AUTH("token"){

        @Override
        public void usernameCheck(String userName) {
            LOGGER.trace("username is not useful for token");
        }

        @Override
        public Credentials buildCredentials(String credentialsData) {
            return new Credentials(this, null, credentialsData);
        }

        @Override
        public String toString(String username) {
            return this.name() + "(<withheld>)";
        }
    };

    private static final Logger LOGGER;
    public final String secretName;

    private CredentialsType(String secretName) {
        this.secretName = secretName;
    }

    public abstract void usernameCheck(String var1);

    public abstract Credentials buildCredentials(String var1);

    public abstract String toString(String var1);

    public static CredentialsType decode(String name) {
        try {
            return Enum.valueOf(CredentialsType.class, name);
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidTestPlanException(name + " is not a valid authentication type", ex);
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(CredentialsType.class);
    }
}

