/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.squash.automation.tm.testplan.library.model.testspecs;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.serde.annotation.Serdeable;
import java.util.HashMap;
import java.util.Map;
import org.squashtest.squash.automation.tm.testplan.library.model.Credentials;
import org.squashtest.squash.automation.tm.testplan.library.model.CredentialsType;
import org.squashtest.squash.automation.tm.testplan.library.model.InvalidTestPlanException;

@Serdeable
@Introspected
@JsonIgnoreProperties
public class Test {
    private static final String TC_AUTH_DATA_PARM_KEY = "AUTOM_SOURCE_CODE_REPOSITORY_AUTHENTICATION";
    private static final String TC_AUTH_TYPE_PARM_KEY = "AUTOM_SOURCE_CODE_REPOSITORY_AUTHENTICATION_TYPE";
    private String id;
    private Long tmProjectId;
    private Map<String, String> param = new HashMap<String, String>();
    private Map<String, Object> metadata = new HashMap<String, Object>();

    public Map<String, String> getParam() {
        return this.param;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setParam(Map<String, String> param) {
        this.param = param;
    }

    public synchronized void addParam(String name, String value) {
        if (this.param == null) {
            this.param = new HashMap<String, String>();
        }
        this.param.put(name, value);
    }

    public void addMetadata(String name, Object value) {
        this.metadata.put(name, value);
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public Credentials extractCredentials() {
        if (this.getParam().containsKey(TC_AUTH_DATA_PARM_KEY)) {
            CredentialsType credentialsType = this.credentialsType();
            return credentialsType.buildCredentials(this.authData());
        }
        return null;
    }

    private CredentialsType credentialsType() throws InvalidTestPlanException {
        String authTypeString = this.authType();
        if (authTypeString == null) {
            throw new InvalidTestPlanException("Missing the mandatory auth type test case parameter");
        }
        return CredentialsType.decode(authTypeString);
    }

    private String authType() {
        return this.getParam().get(TC_AUTH_TYPE_PARM_KEY);
    }

    private String authData() {
        return this.getParam().get(TC_AUTH_DATA_PARM_KEY);
    }

    public Long getTmProjectId() {
        return this.tmProjectId;
    }

    public void setTmProjectId(Long tmProjectId) {
        this.tmProjectId = tmProjectId;
    }
}

