/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.squash.automation.tm.testplan.library.model.mapper;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.squashtest.squash.automation.tm.testplan.library.model.InvalidTestPlanException;
import org.squashtest.squash.automation.tm.testplan.library.model.ProjectIdAndSourceVersion;
import org.squashtest.squash.automation.tm.testplan.library.model.SourceVersion;
import org.squashtest.squash.automation.tm.testplan.library.model.testspecs.Test;

public class TmProjectIdAndSourceVersionMapper
implements Consumer<Test> {
    private final Map<ProjectIdAndSourceVersion, List<Test>> projectIdAndSourceVersionMap = new HashMap<ProjectIdAndSourceVersion, List<Test>>();

    @Override
    public void accept(Test test) {
        try {
            String testRepositoryUrl = test.getParam().get("AUTOM_SOURCE_CODE_REPOSITORY_URL");
            String referenceName = test.getParam().get("AUTOM_SOURCE_CODE_REPOSITORY_BRANCH");
            SourceVersion sourceVersion = new SourceVersion(new URL(testRepositoryUrl), referenceName);
            ProjectIdAndSourceVersion projectIdAndSourceVersion = new ProjectIdAndSourceVersion(test.getTmProjectId(), sourceVersion);
            if (!this.projectIdAndSourceVersionMap.containsKey(projectIdAndSourceVersion)) {
                ArrayList<Test> testList = new ArrayList<Test>();
                testList.add(test);
                this.projectIdAndSourceVersionMap.put(projectIdAndSourceVersion, testList);
            } else {
                this.projectIdAndSourceVersionMap.get(projectIdAndSourceVersion).add(test);
            }
        }
        catch (MalformedURLException ex) {
            throw new InvalidTestPlanException("Malformed URL received from Squash TM", ex);
        }
    }

    public Map<ProjectIdAndSourceVersion, List<Test>> getProjectIdAndSourceVersionMap() {
        return this.projectIdAndSourceVersionMap;
    }
}

