/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.squash.automation.tm.testplan.library.model.mapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.squash.automation.tm.commons.TestExecutionDTO;
import org.squashtest.squash.automation.tm.testplan.library.model.Credentials;
import org.squashtest.squash.automation.tm.testplan.library.model.ExecutionConfiguration;
import org.squashtest.squash.automation.tm.testplan.library.model.InvalidTestPlanException;
import org.squashtest.squash.automation.tm.testplan.library.model.Project;
import org.squashtest.squash.automation.tm.testplan.library.model.ProjectIdAndSourceVersion;
import org.squashtest.squash.automation.tm.testplan.library.model.SourceVersion;
import org.squashtest.squash.automation.tm.testplan.library.model.TestExecution;
import org.squashtest.squash.automation.tm.testplan.library.model.mapper.TestToTestExecution;
import org.squashtest.squash.automation.tm.testplan.library.model.testspecs.Test;

public class ProjectBuilder
implements BiConsumer<ProjectIdAndSourceVersion, List<Test>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectBuilder.class);
    private static final String MISSING_TECHNOLOGY_ERROR_MESSAGE = "Missing technology for test %s of project %s";
    private static final String INCONSISTENT_TECHNOLOGY_ERROR_MESSAGE = "Inconsistent technology for test project %s, test %s has technology %s but test %s has %s";
    private final List<Project> projectList = new ArrayList<Project>();
    private final List<TestExecutionDTO> testExecutionsToTransmit = new ArrayList<TestExecutionDTO>();
    private final Collection<ExecutionConfiguration> configurations;

    public ProjectBuilder(Collection<ExecutionConfiguration> configurations) {
        this.configurations = configurations;
    }

    @Override
    public void accept(ProjectIdAndSourceVersion projectIdAndSourceVersion, List<Test> testList) {
        List<TestExecution> testRefList = this.convertTestsToTestExecutions(testList);
        Pair<Credentials, String> credentialsAndCategory = this.validateAndReturnCredentialsAndCategory(testList);
        Long tmProjectId = projectIdAndSourceVersion.getTmProjectId();
        SourceVersion scmRepository = projectIdAndSourceVersion.getScmRepository();
        ExecutionConfiguration projectConfiguration = this.extractProjectConfiguration(tmProjectId);
        List<String> environmentTags = this.extractEnvironmentTagsFromExecutionConfiguration(projectConfiguration);
        Map<String, Object> environmentVariables = this.extractEnvironmentVariablesFromExecutionConfiguration(projectConfiguration);
        Project project = new Project(scmRepository, (Credentials)credentialsAndCategory.getLeft(), (String)credentialsAndCategory.getRight(), testRefList, environmentTags, environmentVariables);
        this.projectList.add(project);
        testRefList.forEach(testExecution -> this.testExecutionsToTransmit.add(new TestExecutionDTO(testExecution.getDefinition(), testExecution.getStepId(), testExecution.getTestId(), project.toolCategory, environmentTags, environmentVariables)));
    }

    private Pair<Credentials, String> validateAndReturnCredentialsAndCategory(List<Test> testList) {
        String toolCategory = null;
        String testForToolCategory = null;
        Credentials credentials = null;
        for (Test test : testList) {
            String testToolCategory = test.getParam().get("AUTOM_AUTOMATED_TEST_TECHNOLOGY_ACTION_PROVIDER_KEY");
            if (testToolCategory == null) {
                throw new InvalidTestPlanException(String.format(MISSING_TECHNOLOGY_ERROR_MESSAGE, test.getParam().get("AUTOM_AUTOMATED_TEST_REFERENCE"), test.getParam().get("AUTOM_SOURCE_CODE_REPOSITORY_URL")));
            }
            if (toolCategory == null) {
                toolCategory = testToolCategory;
                testForToolCategory = test.getParam().get("AUTOM_AUTOMATED_TEST_REFERENCE");
            } else if (!toolCategory.equals(testToolCategory)) {
                throw new InvalidTestPlanException(String.format(INCONSISTENT_TECHNOLOGY_ERROR_MESSAGE, test.getParam().get("AUTOM_SOURCE_CODE_REPOSITORY_URL"), testForToolCategory, toolCategory, test.getParam().get("AUTOM_AUTOMATED_TEST_REFERENCE"), testToolCategory));
            }
            if (credentials == null) {
                credentials = test.extractCredentials();
                continue;
            }
            if (credentials.equals(test.extractCredentials())) continue;
            LOGGER.warn("Inconsistent credentials parameters between tests. Only the first one will be used");
        }
        return Pair.of(credentials, toolCategory);
    }

    private List<TestExecution> convertTestsToTestExecutions(List<Test> testList) {
        return testList.stream().map(new TestToTestExecution()).collect(Collectors.toList());
    }

    private ExecutionConfiguration extractProjectConfiguration(Long tmProjectId) {
        return this.configurations.stream().filter(configuration -> configuration.getTmProjectId().equals(tmProjectId)).findAny().orElse(null);
    }

    private List<String> extractEnvironmentTagsFromExecutionConfiguration(ExecutionConfiguration projectConfiguration) {
        if (Objects.nonNull(projectConfiguration)) {
            return projectConfiguration.getEnvironmentTags();
        }
        return new ArrayList<String>();
    }

    private Map<String, Object> extractEnvironmentVariablesFromExecutionConfiguration(ExecutionConfiguration projectConfiguration) {
        if (Objects.nonNull(projectConfiguration)) {
            return projectConfiguration.getEnvironmentVariables();
        }
        return new HashMap<String, Object>();
    }

    public List<Project> projectList() {
        return new ArrayList<Project>(this.projectList);
    }

    public List<TestExecutionDTO> testExecutionsToTransmit() {
        return new ArrayList<TestExecutionDTO>(this.testExecutionsToTransmit);
    }
}

