/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.squash.automation.tm.testplan.library.model;

import io.micronaut.core.annotation.Introspected;
import io.micronaut.serde.annotation.Serdeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@Serdeable
@Introspected
public class TestPlanContext {
    private String entityType;
    private String entityName;
    private String entityPath;
    private String entityUuid;
    private String squashTMVersion;

    public TestPlanContext(String entityType, String entityName, String entityPath, String entityUuid, String squashTMVersion) {
        this.entityUuid = entityUuid;
        this.entityName = entityName;
        this.entityType = entityType;
        this.entityPath = entityPath;
        this.squashTMVersion = squashTMVersion;
    }

    public TestPlanContext() {
    }

    public String getEntityType() {
        return this.entityType;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public List<String> getEntityPathAsList() {
        if (Objects.isNull(this.entityPath)) {
            return List.of();
        }
        return new ArrayList<String>(Arrays.asList(this.entityPath.split(" > ")));
    }

    public String getEntityUuid() {
        return this.entityUuid;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public void setEntityPath(String entityPath) {
        this.entityPath = entityPath;
    }

    public void setEntityUuid(String entityUuid) {
        this.entityUuid = entityUuid;
    }

    public String getSquashTMVersion() {
        return this.squashTMVersion;
    }
}

