/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.squash.automation.tm.testplan.library.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class TestExecution {
    private String definition;
    private Map<String, String> params;
    private Map<String, Object> metadata;
    private String testId;
    private String stepId;

    public TestExecution(String definition, Map<String, String> params, String testId) {
        this.definition = Objects.requireNonNull(definition, "definition must not be empty");
        this.params = Objects.requireNonNull(params, "params may be emtpy but not null");
        this.testId = Objects.requireNonNull(testId, "testId must not be empty");
        this.stepId = UUID.randomUUID().toString();
        this.metadata = new HashMap<String, Object>();
        this.metadata.put("exec_step_id", this.stepId);
    }

    public void addMetadata(String key, Object value) {
        this.metadata.put(key, value);
    }

    public Object getMetadata(String key) {
        return this.getMetadata().get(key);
    }

    public void putAllMetadata(Map<String, Object> metadata) {
        this.metadata.putAll(metadata);
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public String getDefinition() {
        return this.definition;
    }

    public Map<String, String> getParams() {
        return Collections.unmodifiableMap(this.params);
    }

    public String getTestId() {
        return this.testId;
    }

    public String getStepId() {
        return this.stepId;
    }
}

