/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.squash.automation.tm.testplan.library.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.squashtest.squash.automation.tm.testplan.library.model.Credentials;
import org.squashtest.squash.automation.tm.testplan.library.model.SourceVersion;
import org.squashtest.squash.automation.tm.testplan.library.model.TestExecution;

public class Project {
    public final SourceVersion testRepository;
    public final Credentials testRepositoryCredentials;
    public final String toolCategory;
    private List<TestExecution> tests;
    private Collection<String> environmentTags = new ArrayList<String>();
    private Map<String, Object> environmentVariables;

    public Project(SourceVersion testRepository, List<TestExecution> tests, String toolCategory, Credentials testRepositoryCredentials) {
        this.testRepository = Objects.requireNonNull(testRepository, "The test repository is mandatory.");
        this.tests = Objects.requireNonNull(tests, "Test list is mandatory");
        this.toolCategory = Objects.requireNonNull(toolCategory, "Tool category is mandatory");
        this.testRepositoryCredentials = testRepositoryCredentials;
    }

    public Project(SourceVersion testRepository, Credentials testRepositoryCredentials, String toolCategory, List<TestExecution> tests, Collection<String> environmentTags, Map<String, Object> environmentVariables) {
        this(testRepository, tests, toolCategory, testRepositoryCredentials);
        this.environmentTags = Objects.requireNonNull(environmentTags);
        this.environmentVariables = Objects.requireNonNull(environmentVariables);
    }

    public List<TestExecution> getTests() {
        return Collections.unmodifiableList(this.tests);
    }

    public Collection<String> getEnvironmentTags() {
        return Collections.unmodifiableCollection(this.environmentTags);
    }

    public Map<String, Object> getEnvironmentVariables() {
        return this.environmentVariables;
    }
}

