/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.squash.automation.tm.testplan.library.model;

import java.util.Objects;
import org.squashtest.squash.automation.tm.testplan.library.model.CredentialsType;

public class Credentials {
    public final CredentialsType type;
    public final String username;
    public final String secret;

    public Credentials(CredentialsType type, String username, String secret) {
        type.usernameCheck(username);
        this.type = Objects.requireNonNull(type, "Credentials type is mandatory");
        this.username = username;
        this.secret = Objects.requireNonNull(secret, type.secretName + " is mandatory.");
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode((Object)this.type);
        hash = 97 * hash + Objects.hashCode(this.username);
        hash = 97 * hash + Objects.hashCode(this.secret);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Credentials other = (Credentials)obj;
        if (!Objects.equals(this.username, other.username)) {
            return false;
        }
        if (!Objects.equals(this.secret, other.secret)) {
            return false;
        }
        return this.type == other.type;
    }

    public String toString() {
        return this.type.toString(this.username);
    }
}

