/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.squash.automation.tm.commons;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.serde.annotation.Serdeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opentestfactory.dto.v1.EventDtoBase;
import org.opentestfactory.messages.OTFMessage;
import org.opentestfactory.utils.ObjectUtils;
import org.squashtest.squash.automation.tm.commons.TestExecutionDTO;

@JsonIgnoreProperties(ignoreUnknown=true)
@Introspected
@Serdeable
public class ExpectedSuiteDefinition
extends OTFMessage
implements EventDtoBase {
    private Map<String, Object> with;

    public ExpectedSuiteDefinition(@JsonProperty(value="apiVersion") String apiVersion, @JsonProperty(value="with") Map<String, Object> with) {
        super(apiVersion);
        this.with = with;
    }

    public String squashTMUrl() {
        if (this.getWith().containsKey("squashTMUrl")) {
            return this.getWith().get("squashTMUrl").toString();
        }
        return null;
    }

    public String automatedServerLogin() {
        if (this.getWith().containsKey("automatedServerLogin")) {
            return this.getWith().get("automatedServerLogin").toString();
        }
        return null;
    }

    public String automatedServerPassword() {
        if (this.getWith().containsKey("automatedServerPassword")) {
            return this.getWith().get("automatedServerPassword").toString();
        }
        return null;
    }

    public String automatedServerToken() {
        if (this.getWith().containsKey("automatedServerToken")) {
            return this.getWith().get("automatedServerToken").toString();
        }
        return null;
    }

    public String suiteId() {
        if (this.getWith().containsKey("suiteId")) {
            return this.getWith().get("suiteId").toString();
        }
        return null;
    }

    public List<TestExecutionDTO> testExecutions() {
        if (this.getWith().containsKey("testExecutions")) {
            List execList = (List)this.getWith().get("testExecutions");
            return execList.stream().map(exec -> new TestExecutionDTO((String)exec.get("testDefinition"), (String)exec.get("stepId"), (String)exec.get("testId"), (String)exec.get("testTechnology"), (List)exec.get("environmentTags"), (Map)exec.get("environmentVariables"))).collect(Collectors.toList());
        }
        return new ArrayList<TestExecutionDTO>();
    }

    public String getKind() {
        return "ExpectedSuiteDefinition";
    }

    public String workflowId() {
        return (String)this.getMetadata().get("workflow_id");
    }

    public String name() {
        return (String)this.getMetadata().get("name");
    }

    public String jobId() {
        return (String)this.getMetadata().get("job_id");
    }

    public List<String> jobOrigin() {
        return (List)this.getMetadata().get("job_origin");
    }

    public Map<String, Object> getWith() {
        return Collections.unmodifiableMap((Map)ObjectUtils.nonNullOrElse(this.with, Collections.emptyMap()));
    }

    public String getSquashTMVersion() {
        return this.getMetadata().getOrDefault("squash_tm_version", null);
    }
}

