/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.core.dbsupport;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Set;
import org.unitils.core.UnitilsException;
import org.unitils.core.dbsupport.DbSupport;
import org.unitils.thirdparty.org.apache.commons.dbutils.DbUtils;

public class H2DbSupport
extends DbSupport {
    public H2DbSupport() {
        super("h2");
    }

    public Set<String> getTableNames() {
        return this.getSQLHandler().getItemsAsStringSet("select TABLE_NAME from INFORMATION_SCHEMA.TABLES where TABLE_TYPE = 'TABLE' AND TABLE_SCHEMA = '" + this.getSchemaName() + "'");
    }

    public Set<String> getColumnNames(String tableName) {
        return this.getSQLHandler().getItemsAsStringSet("select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = '" + tableName + "' AND TABLE_SCHEMA = '" + this.getSchemaName() + "'");
    }

    public Set<String> getIdentityColumnNames(String tableName) {
        return this.getSQLHandler().getItemsAsStringSet("select COLUMN_NAME from INFORMATION_SCHEMA.INDEXES where PRIMARY_KEY = 'TRUE' AND TABLE_NAME = '" + tableName + "' AND TABLE_SCHEMA = '" + this.getSchemaName() + "'");
    }

    public Set<String> getViewNames() {
        return this.getSQLHandler().getItemsAsStringSet("select TABLE_NAME from INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA = '" + this.getSchemaName() + "'");
    }

    public Set<String> getSequenceNames() {
        return this.getSQLHandler().getItemsAsStringSet("select SEQUENCE_NAME from INFORMATION_SCHEMA.SEQUENCES where SEQUENCE_SCHEMA = '" + this.getSchemaName() + "'");
    }

    public Set<String> getTriggerNames() {
        return this.getSQLHandler().getItemsAsStringSet("select TRIGGER_NAME from INFORMATION_SCHEMA.TRIGGERS where TRIGGER_SCHEMA = '" + this.getSchemaName() + "'");
    }

    public long getSequenceValue(String sequenceName) {
        return this.getSQLHandler().getItemAsLong("select CURRENT_VALUE from INFORMATION_SCHEMA.SEQUENCES where SEQUENCE_SCHEMA = '" + this.getSchemaName() + "' and SEQUENCE_NAME = '" + sequenceName + "'");
    }

    public void incrementSequenceToValue(String sequenceName, long newSequenceValue) {
        this.getSQLHandler().executeUpdate("alter sequence " + this.qualified(sequenceName) + " restart with " + newSequenceValue);
    }

    public void incrementIdentityColumnToValue(String tableName, String identityColumnName, long identityValue) {
        this.getSQLHandler().executeUpdate("alter table " + this.qualified(tableName) + " alter column " + this.quoted(identityColumnName) + " RESTART WITH " + identityValue);
    }

    public void disableReferentialConstraints() {
        this.getSQLHandler().executeUpdate("SET REFERENTIAL_INTEGRITY FALSE");
    }

    public void disableValueConstraints() {
        this.disableCheckAndUniqueConstraints();
        this.disableNotNullConstraints();
    }

    protected void disableCheckAndUniqueConstraints() {
        Connection connection = null;
        Statement queryStatement = null;
        Statement alterStatement = null;
        ResultSet resultSet = null;
        try {
            try {
                connection = this.getSQLHandler().getDataSource().getConnection();
                queryStatement = connection.createStatement();
                alterStatement = connection.createStatement();
                resultSet = queryStatement.executeQuery("select TABLE_NAME, CONSTRAINT_NAME from INFORMATION_SCHEMA.CONSTRAINTS where CONSTRAINT_TYPE IN ('CHECK', 'UNIQUE') AND CONSTRAINT_SCHEMA = '" + this.getSchemaName() + "'");
                while (resultSet.next()) {
                    String tableName = resultSet.getString("TABLE_NAME");
                    String constraintName = resultSet.getString("CONSTRAINT_NAME");
                    alterStatement.executeUpdate("alter table " + this.qualified(tableName) + " drop constraint " + this.quoted(constraintName));
                }
            }
            catch (Exception e) {
                throw new UnitilsException("Error while disabling check and unique constraints on schema " + this.getSchemaName(), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(queryStatement);
            DbUtils.closeQuietly((Connection)connection, alterStatement, resultSet);
            throw throwable;
        }
        DbUtils.closeQuietly((Statement)queryStatement);
        DbUtils.closeQuietly((Connection)connection, (Statement)alterStatement, (ResultSet)resultSet);
    }

    protected void disableNotNullConstraints() {
        Connection connection = null;
        Statement queryStatement = null;
        Statement alterStatement = null;
        ResultSet resultSet = null;
        try {
            try {
                connection = this.getSQLHandler().getDataSource().getConnection();
                queryStatement = connection.createStatement();
                alterStatement = connection.createStatement();
                resultSet = queryStatement.executeQuery("select col.TABLE_NAME, col.COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS col where col.IS_NULLABLE = 'NO' and col.TABLE_SCHEMA = '" + this.getSchemaName() + "' " + "AND NOT EXISTS (select COLUMN_NAME " + "from INFORMATION_SCHEMA.INDEXES pk where pk.TABLE_NAME = " + "col.TABLE_NAME and pk.COLUMN_NAME = col.COLUMN_NAME and " + "pk.TABLE_SCHEMA = '" + this.getSchemaName() + "' AND pk.PRIMARY_KEY = TRUE)");
                while (resultSet.next()) {
                    String tableName = resultSet.getString("TABLE_NAME");
                    String columnName = resultSet.getString("COLUMN_NAME");
                    alterStatement.executeUpdate("alter table " + this.qualified(tableName) + " alter column " + this.quoted(columnName) + " set null");
                }
            }
            catch (Exception e) {
                throw new UnitilsException("Error while disabling not null constraints on schema " + this.getSchemaName(), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(queryStatement);
            DbUtils.closeQuietly((Connection)connection, alterStatement, resultSet);
            throw throwable;
        }
        DbUtils.closeQuietly((Statement)queryStatement);
        DbUtils.closeQuietly((Connection)connection, (Statement)alterStatement, (ResultSet)resultSet);
    }

    public boolean supportsSequences() {
        return true;
    }

    public boolean supportsTriggers() {
        return true;
    }

    public boolean supportsIdentityColumns() {
        return true;
    }

    public boolean supportsCascade() {
        return true;
    }
}

