/**
 *     This file is part of the Squashtest platform.
 *     Copyright (C) 2010 - 2011 Squashtest TM, Squashtest.org
 *
 *     See the NOTICE file distributed with this work for additional
 *     information regarding copyright ownership.
 *
 *     This is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Lesser General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     this software is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU Lesser General Public License for more details.
 *
 *     You should have received a copy of the GNU Lesser General Public License
 *     along with this software.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.squashtest.csp.tm.domain.attachment;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;

@Entity
public class AttachmentList {

	@Id
	@GeneratedValue
	@Column(name = "ATTACHMENT_LIST_ID")
	private Long id;

	@OneToMany(cascade = { CascadeType.ALL })
	@JoinColumn(name = "ATTACHMENT_LIST_ID", nullable = false, updatable = false)
	private final Set<Attachment> attachments = new HashSet<Attachment>();

	public Long getId() {
		return id;
	}

	public void addAttachment(Attachment attachment) {
		attachments.add(attachment);
	}

	public void removeAttachment(Attachment attachment) {
		removeAttachment(attachment.getId());
	}

	public void removeAttachment(long attachmentId) {
		Iterator<Attachment> iter = attachments.iterator();
		while (iter.hasNext()) {
			Attachment at = iter.next();
			if (at.getId() == attachmentId) {
				iter.remove();
				break;
			}
		}
	}

	public Attachment getAttachmentById(long attachmentId) {
		Attachment result = null;

		for (Attachment at : attachments) {
			if (at.getId() == attachmentId) {
				result = at;
				break;
			}
		}

		return result;
	}

	public boolean hasAttachments() {
		return (attachments.size() > 0);
	}

	public Set<Attachment> getAllAttachments() {
		return attachments;
	}

	public int size() {
		return getAllAttachments().size();
	}

}
