/**
 *     This file is part of the Squashtest platform.
 *     Copyright (C) 2010 - 2011 Squashtest TM, Squashtest.org
 *
 *     See the NOTICE file distributed with this work for additional
 *     information regarding copyright ownership.
 *
 *     This is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Lesser General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     this software is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU Lesser General Public License for more details.
 *
 *     You should have received a copy of the GNU Lesser General Public License
 *     along with this software.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.squashtest.csp.tm.domain.attachment;

import java.io.InputStream;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;

import org.hibernate.annotations.Type;

@Entity
public class AttachmentContent {

	@Id
	@GeneratedValue
	@Column(name = "ATTACHMENT_CONTENT_ID")
	private Long id;

	@Lob
	@Basic(fetch = FetchType.LAZY)
	@Type(type = "org.squashtest.csp.tm.internal.infrastructure.hibernate.BlobUserType")
	private InputStream streamContent;

	public InputStream getContent() {
		return streamContent;
	}

	public void setContent(InputStream content) {
		this.streamContent = content;
	}

	public AttachmentContent hardCopy() {
		AttachmentContent clone = new AttachmentContent();

		// note : we don't really deep copy the input stream here since Hibernate won't care : it's not an entity,
		// whereas the
		// AttachmentContent is. Do you really want to clone an input stream anyway ?
		clone.streamContent = this.streamContent;
		return clone;
	}

	public Long getId() {
		return id;
	}

}
