/*
 * Decompiled with CFR 0.152.
 */
package org.cubictest.persistence;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.cubictest.common.utils.ErrorHandler;
import org.cubictest.common.utils.FileUtil;
import org.cubictest.model.parameterization.Parameter;
import org.cubictest.model.parameterization.ParameterList;
import org.cubictest.persistence.CubicTestXStream;
import org.cubictest.persistence.TestPersistance;
import org.eclipse.core.resources.IFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterPersistance {
    public static final Logger LOGGER = LoggerFactory.getLogger(ParameterPersistance.class);

    public static void saveToFile(ParameterList paramList, IFile iFile) {
        File f = iFile.getLocation().toFile();
        ParameterPersistance.saveToFile(paramList, f);
    }

    public static void saveToFile(ParameterList paramList, File file) {
        String xml = new CubicTestXStream().toXML((Object)paramList);
        try {
            String charset = TestPersistance.getCharset((File)file);
            String charsetHeader = TestPersistance.getCharsetHeader((String)charset);
            xml = charsetHeader + "\n" + xml;
            FileUtils.writeStringToFile((File)file, (String)xml, (String)charset);
        }
        catch (IOException e) {
            ErrorHandler.logAndRethrow((Throwable)e);
        }
    }

    public static ParameterList loadFromFile(String fileName) {
        File file = FileUtil.getFileFromClassPath(fileName);
        String xml = "";
        try {
            String charset = TestPersistance.getCharset((File)file);
            xml = FileUtils.readFileToString((File)file, (String)charset);
        }
        catch (IOException e) {
            ErrorHandler.logAndRethrow((Throwable)e);
        }
        try {
            ParameterList list = (ParameterList)new CubicTestXStream().fromXML(xml);
            list.setFileName(fileName);
            return list;
        }
        catch (Exception e) {
            return ParameterPersistance.manualParseFromFile(fileName);
        }
    }

    private static ParameterList manualParseFromFile(String fileName) {
        File file = FileUtil.getFileFromClassPath(fileName);
        ParameterList list = new ParameterList();
        list.setFileName(fileName);
        try {
            FileReader fr = new FileReader(file);
            BufferedReader bw = new BufferedReader(fr);
            String line = bw.readLine();
            if (line == null) {
                return list;
            }
            for (String token : line.split(";")) {
                Parameter param = new Parameter();
                param.setHeader(token.trim());
                list.addParameter(param);
            }
            line = bw.readLine();
            while (line != null) {
                int i = 0;
                for (String token : line.split(";")) {
                    ((Parameter)list.getParameters().get(i++)).addParameterInput(token.trim());
                }
                line = bw.readLine();
            }
            bw.close();
        }
        catch (FileNotFoundException e) {
            ErrorHandler.logAndShowErrorDialogAndRethrow((Throwable)e);
        }
        catch (IOException e) {
            ErrorHandler.logAndShowErrorDialogAndRethrow((Throwable)e);
        }
        return list;
    }
}

