/*
 * Decompiled with CFR 0.152.
 */
package org.cubictest.common.utils;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import org.cubictest.export.exceptions.ExporterException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class FileUtil {
    public static File getFileFromWorkspaceRoot(String fileName) {
        try {
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fileName)).getLocation().toFile();
        }
        catch (Exception e) {
            File result = new File("../" + fileName);
            if (!result.exists()) {
                throw new ExporterException("File not found: " + result.getAbsolutePath());
            }
            return result;
        }
    }

    public static File getFileFromClassPath(String fileName) {
        URL url;
        if (fileName.startsWith("/")) {
            fileName = fileName.substring(1);
        }
        if ((url = Thread.currentThread().getContextClassLoader().getResource(fileName)) == null) {
            throw new ExporterException("File not found: " + fileName);
        }
        File result = null;
        try {
            result = new File(url.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return result;
    }
}

